"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MlJobUpgradeModalBody = exports.ML_JOB_UPGRADE_MODAL_TITLE = exports.ML_JOB_UPGRADE_MODAL_CONFIRM = exports.ML_JOB_UPGRADE_MODAL_CANCEL = exports.ML_JOB_UPGRADE_MODAL_AFFECTED_JOBS = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _links_to_docs = require("../../../../../../common/components/links_to_docs");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_management_ui/components/rules_table/upgrade_prebuilt_rules_table/use_ml_jobs_upgrade_modal/translations.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ML_JOB_UPGRADE_MODAL_TITLE = exports.ML_JOB_UPGRADE_MODAL_TITLE = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.mlJobUpgradeModal.messageTitle', {
  defaultMessage: 'ML rule updates may override your existing rules'
});
const ML_JOB_UPGRADE_MODAL_CANCEL = exports.ML_JOB_UPGRADE_MODAL_CANCEL = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.mlJobUpgradeModal.cancelTitle', {
  defaultMessage: 'Cancel'
});
const ML_JOB_UPGRADE_MODAL_CONFIRM = exports.ML_JOB_UPGRADE_MODAL_CONFIRM = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.mlJobUpgradeModal.confirmTitle', {
  defaultMessage: 'Load rules'
});
const ML_JOB_UPGRADE_MODAL_AFFECTED_JOBS = exports.ML_JOB_UPGRADE_MODAL_AFFECTED_JOBS = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.mlJobUpgradeModal.affectedJobsTitle', {
  defaultMessage: 'Affected jobs:'
});
const MlJobUpgradeModalBody = () => /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.securitySolution.detectionEngine.mlJobUpgradeModal.messageBody",
  defaultMessage: "{summary} Documentation: {docs}",
  values: {
    summary: /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 47,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.detectionEngine.mlJobUpgradeModal.messageBody.summary",
      defaultMessage: "New V3 machine learning jobs have been released, and the latest corresponding prebuilt detection rules now use these new ML jobs. You're currently running one or more V1/V2 jobs, which only work with legacy prebuilt rules. To ensure continued coverage using V1/V2 jobs, you may need to duplicate or create new rules before updating your Elastic prebuilt detection rules. Check the documentation below for instructions on how to keep using the V1/V2 jobs, and how to start using the new V3 jobs.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 48,
        columnNumber: 11
      }
    })),
    docs: /*#__PURE__*/_react.default.createElement("ul", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 62,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement("li", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 63,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_links_to_docs.MlJobCompatibilityLink, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 64,
        columnNumber: 13
      }
    })))
  },
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 42,
    columnNumber: 3
  }
});
exports.MlJobUpgradeModalBody = MlJobUpgradeModalBody;