"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RuleExecutionStatusSelector = void 0;
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var i18n = _interopRequireWildcard(require("../../../../common/translations"));
var _detection_engine = require("../../../../../../common/api/detection_engine");
var _utils = require("../../../../common/components/rule_execution_status/utils");
var _rule_execution_status = require("../../../../common/components/rule_execution_status");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_management_ui/components/rules_table/rules_table_filters/rule_execution_status_selector.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * Selector for selecting last rule execution status to filter on
 *
 * @param selectedStatus Selected rule execution status
 * @param onSelectedStatusChanged change listener to be notified when rule execution status selection changes
 */
const RuleExecutionStatusSelectorComponent = ({
  selectedStatus,
  onSelectedStatusChanged
}) => {
  const [isExecutionStatusPopoverOpen, setIsExecutionStatusPopoverOpen] = (0, _react.useState)(false);
  const selectableOptions = [{
    label: (0, _utils.getCapitalizedStatusText)(_detection_engine.RuleExecutionStatusEnum.succeeded) || '',
    data: {
      status: _detection_engine.RuleExecutionStatusEnum.succeeded
    },
    checked: selectedStatus === _detection_engine.RuleExecutionStatusEnum.succeeded ? 'on' : undefined
  }, {
    label: (0, _utils.getCapitalizedStatusText)(_detection_engine.RuleExecutionStatusEnum['partial failure']) || '',
    data: {
      status: _detection_engine.RuleExecutionStatusEnum['partial failure']
    },
    checked: selectedStatus === _detection_engine.RuleExecutionStatusEnum['partial failure'] ? 'on' : undefined
  }, {
    label: (0, _utils.getCapitalizedStatusText)(_detection_engine.RuleExecutionStatusEnum.failed) || '',
    data: {
      status: _detection_engine.RuleExecutionStatusEnum.failed
    },
    checked: selectedStatus === _detection_engine.RuleExecutionStatusEnum.failed ? 'on' : undefined
  }];
  const handleSelectableOptionsChange = (newOptions, _, changedOption) => {
    var _changedOption$data;
    setIsExecutionStatusPopoverOpen(false);
    if (changedOption.checked && changedOption !== null && changedOption !== void 0 && (_changedOption$data = changedOption.data) !== null && _changedOption$data !== void 0 && _changedOption$data.status) {
      onSelectedStatusChanged(changedOption.data.status);
    } else if (!changedOption.checked) {
      onSelectedStatusChanged();
    }
  };
  const triggerButton = /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, {
    grow: true,
    iconType: "arrowDown",
    onClick: () => {
      setIsExecutionStatusPopoverOpen(!isExecutionStatusPopoverOpen);
    },
    numFilters: selectableOptions.length,
    isSelected: isExecutionStatusPopoverOpen,
    hasActiveFilters: selectedStatus !== undefined,
    numActiveFilters: selectedStatus !== undefined ? 1 : 0,
    "data-test-subj": "executionStatusFilterButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 5
    }
  }, i18n.COLUMN_LAST_RESPONSE);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    ownFocus: true,
    button: triggerButton,
    isOpen: isExecutionStatusPopoverOpen,
    closePopover: () => {
      setIsExecutionStatusPopoverOpen(!isExecutionStatusPopoverOpen);
    },
    panelPaddingSize: "none",
    repositionOnScroll: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelectable, {
    "aria-label": i18n.RULE_EXECUTION_STATUS_FILTER,
    options: selectableOptions,
    onChange: handleSelectableOptionsChange,
    singleSelection: true,
    listProps: {
      isVirtualized: false
    },
    renderOption: option => {
      const status = option.status;
      return /*#__PURE__*/_react.default.createElement("div", {
        css: (0, _react2.css)`
                margin-top: 4px; // aligns the badge within the option
              `,
        "data-test-subj": "executionStatusFilterOption",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 110,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_rule_execution_status.RuleStatusBadge, {
        status: status,
        showTooltip: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 116,
          columnNumber: 15
        }
      }));
    },
    "data-test-subj": "executionStatusFilterSelectableList",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 7
    }
  }, list => /*#__PURE__*/_react.default.createElement("div", {
    css: (0, _react2.css)`
              width: 200px;
            `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 11
    }
  }, list)));
};
RuleExecutionStatusSelectorComponent.displayName = 'RuleExecutionStatusSelectorComponent';
const RuleExecutionStatusSelector = exports.RuleExecutionStatusSelector = /*#__PURE__*/_react.default.memo(RuleExecutionStatusSelectorComponent);
RuleExecutionStatusSelector.displayName = 'RuleExecutionStatusSelector';