"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getFailedConnectorsCount = getFailedConnectorsCount;
exports.showToast = showToast;
var _fp = require("lodash/fp");
var i18n = _interopRequireWildcard(require("./translations"));
var _utils = require("../../../../common/components/utils");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getFailedConnectorsCount(actionConnectorsErrors) {
  const connectorIds = new Set(actionConnectorsErrors.filter(connectorError => connectorError.id).flatMap(connectorError => (connectorError.id || '').split(',')));
  return connectorIds.size;
}
function getShortErrorMessage(errorMessages) {
  if (errorMessages.length === 0) {
    return '';
  }
  if (errorMessages.length === 1) {
    return errorMessages[0];
  }
  return i18n.MULTIPLE_ISSUES;
}
function getUserFriendlyConnectorMessages(actionConnectorsErrors) {
  const mappedErrors = actionConnectorsErrors.map(({
    error
  }) => {
    if (error.status_code === 403) {
      return i18n.ACTION_CONNECTORS_ADDITIONAL_PRIVILEGES;
    }
    return error.message;
  });
  return mappedErrors;
}
function showToast({
  importResponse,
  toasts
}) {
  if (importResponse.success_count > 0) {
    toasts.addSuccess(i18n.SUCCESSFULLY_IMPORTED_RULES(importResponse.success_count));
  }
  if (importResponse.exceptions_success_count > 0) {
    toasts.addSuccess(i18n.SUCCESSFULLY_IMPORTED_EXCEPTIONS(importResponse.exceptions_success_count));
  }
  if (importResponse.action_connectors_success_count > 0) {
    toasts.addSuccess(i18n.SUCCESSFULLY_IMPORTED_CONNECTORS(importResponse.action_connectors_success_count));
  }
  const connectorMessages = getUserFriendlyConnectorMessages(importResponse.action_connectors_errors);
  const uniqueActionConnectorMessages = (0, _fp.uniq)(connectorMessages);
  if (uniqueActionConnectorMessages.length > 0) {
    (0, _utils.showErrorToast)({
      title: i18n.CONNECTOR_IMPORT_FAILED(getFailedConnectorsCount(importResponse.action_connectors_errors)),
      shortMessage: getShortErrorMessage(uniqueActionConnectorMessages),
      fullMessage: JSON.stringify(importResponse.action_connectors_errors, null, 2),
      toasts
    });
  }
  const uniqueRuleErrors = (0, _fp.uniq)(importResponse.errors.map(error => error.error.message));
  if (uniqueRuleErrors.length > 0) {
    (0, _utils.showErrorToast)({
      title: i18n.RULE_IMPORT_FAILED(importResponse.errors.length),
      shortMessage: getShortErrorMessage(uniqueRuleErrors),
      fullMessage: JSON.stringify(importResponse.errors, null, 2),
      toasts
    });
  }
  const uniqueExceptionErrors = (0, _fp.uniq)(importResponse.exceptions_errors.map(error => error.error.message));
  if (uniqueExceptionErrors.length > 0) {
    (0, _utils.showErrorToast)({
      title: i18n.EXCEPTION_IMPORT_FAILED(importResponse.exceptions_errors.length),
      shortMessage: getShortErrorMessage(uniqueExceptionErrors),
      fullMessage: JSON.stringify(importResponse.exceptions_errors, null, 2),
      toasts
    });
  }
}