"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndexPatternField = IndexPatternField;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _css = require("@emotion/css");
var _eui = require("@elastic/eui");
var _use_default_index_pattern = require("../../../../../../hooks/use_default_index_pattern");
var _shared_imports = require("../../../../../../../../shared_imports");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_management/components/rule_details/three_way_diff/final_edit/fields/data_source/index_pattern_edit.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function IndexPatternField({
  field
}) {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const defaultIndexPattern = (0, _use_default_index_pattern.useDefaultIndexPattern)();
  const isIndexModified = !(0, _lodash.isEqual)(field.value, defaultIndexPattern);
  const handleResetIndices = (0, _react.useCallback)(() => field.setValue(defaultIndexPattern), [field, defaultIndexPattern]);
  return /*#__PURE__*/_react.default.createElement(_shared_imports.Field, {
    field: field,
    idAria: "indexPatternEdit",
    "data-test-subj": "indexPatternEdit",
    euiFieldProps: {
      fullWidth: true,
      placeholder: ''
    },
    labelAppend: isIndexModified ? /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      className: (0, _css.css)`
              height: ${euiTheme.size.base};
            `,
      size: "xs",
      iconType: "refresh",
      onClick: handleResetIndices,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 42,
        columnNumber: 11
      }
    }, i18n.RESET_TO_DEFAULT_INDEX_PATTERNS) : undefined,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 32,
      columnNumber: 5
    }
  });
}