"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSelectedTab = void 0;
var _react = require("react");
var _use_stored_state = require("./use_stored_state");
var _integration_context = require("./integration_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useSelectedTab = () => {
  const {
    spaceId,
    integrationTabs
  } = (0, _integration_context.useIntegrationContext)();
  const [selectedTabId, setSelectedTabId] = (0, _use_stored_state.useStoredIntegrationTabId)(spaceId, integrationTabs[0].id);
  const integrationTabsById = (0, _react.useMemo)(() => Object.fromEntries(integrationTabs.map(tab => [tab.id, tab])), [integrationTabs]);
  const selectedTab = (0, _react.useMemo)(() => {
    var _integrationTabsById$;
    return (_integrationTabsById$ = integrationTabsById[selectedTabId]) !== null && _integrationTabsById$ !== void 0 ? _integrationTabsById$ : integrationTabs[0];
  },
  // fallback to first tab if not found
  [integrationTabs, integrationTabsById, selectedTabId]);
  return {
    selectedTab,
    setSelectedTabId
  };
};
exports.useSelectedTab = useSelectedTab;