"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.JobsTableFiltersComponent = exports.JobsTableFilters = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var i18n = _interopRequireWildcard(require("./translations"));
var _groups_filter_popover = require("./groups_filter_popover");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/common/components/ml_popover/jobs_table/filters/jobs_table_filters.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * Collection of filters for filtering data within the JobsTable. Contains search bar, Elastic/Custom
 * Jobs filter button toggle, and groups selection
 *
 * @param securityJobs jobs to fetch groups from to display for filtering
 * @param onFilterChanged change listener to be notified on filter changes
 */
const JobsTableFiltersComponent = ({
  securityJobs,
  onFilterChanged
}) => {
  const [filterQuery, setFilterQuery] = (0, _react.useState)('');
  const [selectedGroups, setSelectedGroups] = (0, _react.useState)([]);
  const [showCustomJobs, setShowCustomJobs] = (0, _react.useState)(false);
  const [showElasticJobs, setShowElasticJobs] = (0, _react.useState)(false);

  // Propagate filter changes to parent
  (0, _react.useEffect)(() => {
    onFilterChanged({
      filterQuery,
      showCustomJobs,
      showElasticJobs,
      selectedGroups
    });
  }, [filterQuery, selectedGroups, showCustomJobs, showElasticJobs, onFilterChanged]);
  const handleChange = (0, _react.useCallback)(query => setFilterQuery(query.queryText.trim()), [setFilterQuery]);
  const handleElasticJobsClick = (0, _react.useCallback)(() => {
    setShowElasticJobs(!showElasticJobs);
    setShowCustomJobs(false);
  }, [setShowElasticJobs, showElasticJobs, setShowCustomJobs]);
  const handleCustomJobsClick = (0, _react.useCallback)(() => {
    setShowCustomJobs(!showCustomJobs);
    setShowElasticJobs(false);
  }, [setShowElasticJobs, showCustomJobs, setShowCustomJobs]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    justifyContent: "flexEnd",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSearchBar, {
    "data-test-subj": "jobs-filter-bar",
    box: {
      placeholder: i18n.FILTER_PLACEHOLDER,
      incremental: true
    },
    onChange: handleChange,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFilterGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_groups_filter_popover.GroupsFilterPopover, {
    securityJobs: securityJobs,
    onSelectedGroupsChanged: setSelectedGroups,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFilterGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, {
    isToggle: true,
    isSelected: showElasticJobs,
    hasActiveFilters: showElasticJobs,
    onClick: handleElasticJobsClick,
    "data-test-subj": "show-elastic-jobs-filter-button",
    withNext: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 11
    }
  }, i18n.SHOW_ELASTIC_JOBS), /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, {
    isToggle: true,
    isSelected: showCustomJobs,
    hasActiveFilters: showCustomJobs,
    onClick: handleCustomJobsClick,
    "data-test-subj": "show-custom-jobs-filter-button",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 11
    }
  }, i18n.SHOW_CUSTOM_JOBS))));
};
exports.JobsTableFiltersComponent = JobsTableFiltersComponent;
JobsTableFiltersComponent.displayName = 'JobsTableFiltersComponent';
const JobsTableFilters = exports.JobsTableFilters = /*#__PURE__*/_react.default.memo(JobsTableFiltersComponent);
JobsTableFilters.displayName = 'JobsTableFilters';