"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SelectInterval = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/common/components/ml/tables/select_interval.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const OPTIONS = [{
  value: 'auto',
  text: i18n.INTERVAL_AUTO
}, {
  value: 'hour',
  text: i18n.INTERVAL_HOUR
}, {
  value: 'day',
  text: i18n.INTERVAL_DAY
}, {
  value: 'second',
  text: i18n.INTERVAL_SHOW_ALL
}];
const SelectInterval = ({
  interval,
  onChange
}) => {
  const onChangeCb = (0, _react.useCallback)(e => {
    onChange(e.target.value);
  }, [onChange]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    "data-test-subj": "selectInterval",
    prepend: i18n.INTERVAL,
    append: /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      content: i18n.INTERVAL_TOOLTIP,
      type: "question",
      color: "subdued",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 46,
        columnNumber: 15
      }
    }),
    options: OPTIONS,
    value: interval,
    onChange: onChangeCb,
    "aria-label": i18n.INTERVAL,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 5
    }
  });
};
exports.SelectInterval = SelectInterval;