"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TimelineMarkDownRendererComponent = exports.TimelineMarkDownRenderer = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _use_upselling = require("../../../../hooks/use_upselling");
var _use_timeline_click = require("../../../../utils/timeline/use_timeline_click");
var i18n = _interopRequireWildcard(require("./translations"));
var _use_app_toasts = require("../../../../hooks/use_app_toasts");
var _user_privileges = require("../../../user_privileges");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/common/components/markdown_editor/plugins/timeline/processor.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const TimelineMarkDownRendererComponent = ({
  id,
  title
}) => {
  const {
    addError
  } = (0, _use_app_toasts.useAppToasts)();
  const interactionsUpsellingMessage = (0, _use_upselling.useUpsellingMessage)('investigation_guide_interactions');
  const {
    timelinePrivileges: {
      read: canReadTimelines
    }
  } = (0, _user_privileges.useUserPrivileges)();
  const isDisabled = !!interactionsUpsellingMessage || !canReadTimelines;
  const handleTimelineClick = (0, _use_timeline_click.useTimelineClick)();
  const onError = (0, _react.useCallback)((error, timelineId) => {
    addError(error, {
      title: i18n.TIMELINE_ERROR_TITLE,
      toastMessage: i18n.FAILED_TO_RETRIEVE_TIMELINE(timelineId)
    });
  }, [addError]);
  const onClickTimeline = (0, _react.useCallback)(() => handleTimelineClick(id !== null && id !== void 0 ? id : '', onError), [id, handleTimelineClick, onError]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: interactionsUpsellingMessage !== null && interactionsUpsellingMessage !== void 0 ? interactionsUpsellingMessage : i18n.TIMELINE_ID(id !== null && id !== void 0 ? id : ''),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    onClick: onClickTimeline,
    disabled: isDisabled,
    "data-test-subj": `markdown-timeline-link-${id}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 7
    }
  }, title));
};
exports.TimelineMarkDownRendererComponent = TimelineMarkDownRendererComponent;
const TimelineMarkDownRenderer = exports.TimelineMarkDownRenderer = /*#__PURE__*/(0, _react.memo)(TimelineMarkDownRendererComponent);