"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getHeaderAlignment = exports.HeaderSection = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _classnames = _interopRequireDefault(require("classnames"));
var _inspect = require("../inspect");
var _subtitle = require("../subtitle");
var i18n = _interopRequireWildcard(require("../../containers/query_toggle/translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/common/components/header_section/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const useStyles = (border, height) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return {
    header: (0, _react2.css)`
      margin-bottom: 0;
      user-select: text;
      ${height ? `height: ${height}px;` : ''}
      ${border ? `border-bottom: ${euiTheme.border.thin}; padding-bottom: ${euiTheme.size.l};` : ''}

      &.toggle-expand {
        margin-bottom: ${euiTheme.size.l};
      }

      .no-margin {
        margin-top: 0 !important;
        margin-bottom: 0 !important;
      }
    `
  };
};
const getHeaderAlignment = ({
  alignHeader,
  stackHeader
}) => {
  if (alignHeader != null) {
    return alignHeader;
  } else if (stackHeader) {
    return undefined;
  } else {
    return 'center';
  }
};
exports.getHeaderAlignment = getHeaderAlignment;
const tooltipIconProps = {
  'data-test-subj': 'header-section-tooltip-icon'
};
const HeaderSectionComponent = ({
  alignHeader,
  border,
  children,
  outerDirection = 'column',
  growLeftSplit = true,
  headerFilters,
  height,
  hideSubtitle = false,
  id,
  inspectMultiple = false,
  inspectTitle,
  isInspectDisabled,
  showInspectButton = true,
  split,
  stackHeader,
  subtitle,
  title,
  titleSize = 'l',
  toggleQuery,
  toggleStatus = true,
  tooltip,
  tooltipTitle,
  toggleAriaLabel
}) => {
  const styles = useStyles(border, height);
  const toggle = (0, _react.useCallback)(() => {
    if (toggleQuery) {
      toggleQuery(!toggleStatus);
    }
  }, [toggleQuery, toggleStatus]);
  const classNames = (0, _classnames.default)({
    'toggle-expand': toggleStatus,
    siemHeaderSection: true
  });
  return /*#__PURE__*/_react.default.createElement("header", {
    css: styles.header,
    "data-test-subj": "header-section",
    className: classNames,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    "data-test-subj": "headerSectionOuterFlexGroup",
    direction: outerDirection,
    gutterSize: "xs",
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: growLeftSplit,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: getHeaderAlignment({
      alignHeader,
      stackHeader
    }),
    "data-test-subj": "headerSectionInnerFlexGroup",
    direction: stackHeader ? 'column' : 'row',
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: growLeftSplit,
    className: toggleStatus ? '' : 'no-margin',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 146,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    responsive: false,
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 147,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 148,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    gutterSize: 'none',
    className: "header-section-titles",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 149,
      columnNumber: 19
    }
  }, toggleQuery && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 155,
      columnNumber: 23
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "data-test-subj": "query-toggle-header",
    "aria-label": [toggleAriaLabel, i18n.QUERY_BUTTON_TITLE(toggleStatus)].filter(Boolean) // remove undefined, empty string, null
    .join(' '),
    color: "text",
    display: "empty",
    iconType: toggleStatus ? 'arrowDown' : 'arrowRight',
    onClick: toggle,
    size: "s",
    title: i18n.QUERY_BUTTON_TITLE(toggleStatus),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 156,
      columnNumber: 25
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 170,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: titleSize,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 171,
      columnNumber: 23
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    "data-test-subj": "header-section-title",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 172,
      columnNumber: 25
    }
  }, /*#__PURE__*/_react.default.createElement("span", {
    className: "eui-textBreakNormal",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 173,
      columnNumber: 27
    }
  }, title), tooltip && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    color: "subdued",
    title: tooltipTitle,
    content: tooltip,
    iconProps: tooltipIconProps,
    size: "l",
    type: "info",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 176,
      columnNumber: 31
    }
  }))))))), id && toggleStatus && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 193,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_inspect.InspectButton, {
    isDisabled: isInspectDisabled,
    queryId: id,
    multiple: inspectMultiple,
    showInspectButton: showInspectButton,
    title: inspectTitle !== null && inspectTitle !== void 0 ? inspectTitle : title,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 194,
      columnNumber: 21
    }
  })), headerFilters && toggleStatus && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "header-section-filters",
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 205,
      columnNumber: 19
    }
  }, headerFilters))), children && toggleStatus && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "header-section-supplements",
    grow: split ? true : false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 213,
      columnNumber: 15
    }
  }, children))), !hideSubtitle && toggleStatus && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 220,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_subtitle.Subtitle, {
    "data-test-subj": "header-section-subtitle",
    items: subtitle,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 221,
      columnNumber: 13
    }
  }))));
};
const HeaderSection = exports.HeaderSection = /*#__PURE__*/_react.default.memo(HeaderSectionComponent);