"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AssetInventoryFilters = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _filter_group = require("@kbn/alerts-ui-shared/src/alert_filter_controls/filter_group");
var _public = require("@kbn/kibana-utils-plugin/public");
var _public2 = require("@kbn/controls-plugin/public");
var _ui_metrics = require("@kbn/cloud-security-posture-common/utils/ui_metrics");
var _analytics = require("@kbn/analytics");
var _use_space_id = require("../../../common/hooks/use_space_id");
var _data_view_context = require("../../hooks/data_view_context");
var _constants = require("../../constants");
var _asset_inventory_filters_loading = require("./asset_inventory_filters_loading");
var _asset_inventory_rule_type_ids = require("./asset_inventory_rule_type_ids");
var _add_empty_data_filter = require("../../utils/add_empty_data_filter");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/asset_inventory/components/filters/asset_inventory_filters.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const DEFAULT_ASSET_INVENTORY_FILTERS = [{
  title: _i18n.i18n.translate('xpack.securitySolution.assetInventory.filters.type', {
    defaultMessage: 'Type'
  }),
  fieldName: _constants.ASSET_FIELDS.ENTITY_TYPE
}, {
  title: _i18n.i18n.translate('xpack.securitySolution.assetInventory.filters.name', {
    defaultMessage: 'Name'
  }),
  fieldName: _constants.ASSET_FIELDS.ENTITY_NAME
}, {
  title: _i18n.i18n.translate('xpack.securitySolution.assetInventory.filters.id', {
    defaultMessage: 'ID'
  }),
  fieldName: _constants.ASSET_FIELDS.ENTITY_ID
}];
const AssetInventoryFilters = ({
  setQuery,
  query
}) => {
  const {
    dataView,
    dataViewIsLoading
  } = (0, _data_view_context.useDataViewContext)();
  const spaceId = (0, _use_space_id.useSpaceId)();
  if (!spaceId || !(dataView !== null && dataView !== void 0 && dataView.id)) {
    // TODO Add error handling if no spaceId is found
    return null;
  }
  if (dataViewIsLoading) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 68,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_asset_inventory_filters_loading.FilterGroupLoading, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 69,
        columnNumber: 9
      }
    }));
  }
  const filters = (0, _add_empty_data_filter.addEmptyDataFilter)(query.filters, dataView.id);
  return /*#__PURE__*/_react.default.createElement(_filter_group.FilterGroup, {
    dataViewId: dataView.id,
    onFiltersChange: pageFilters => {
      pageFilters.forEach(filter => {
        var _filter$meta;
        const field = (_filter$meta = filter.meta) === null || _filter$meta === void 0 ? void 0 : _filter$meta.key;
        if (field === 'entity.name') {
          _ui_metrics.uiMetricService.trackUiMetric(_analytics.METRIC_TYPE.CLICK, _ui_metrics.ASSET_INVENTORY_FILTER_CRITICALITY_APPLIED, _ui_metrics.ASSET_INVENTORY_APP_NAME);
        } else if (field === 'entity.id') {
          _ui_metrics.uiMetricService.trackUiMetric(_analytics.METRIC_TYPE.CLICK, _ui_metrics.ASSET_INVENTORY_FILTER_ID_APPLIED, _ui_metrics.ASSET_INVENTORY_APP_NAME);
        } else {
          _ui_metrics.uiMetricService.trackUiMetric(_analytics.METRIC_TYPE.CLICK, _ui_metrics.ASSET_INVENTORY_FILTER_TYPE_APPLIED, _ui_metrics.ASSET_INVENTORY_APP_NAME);
        }
      });
      setQuery({
        pageFilters
      });
    },
    ruleTypeIds: _asset_inventory_rule_type_ids.ASSET_INVENTORY_RULE_TYPE_IDS,
    Storage: _public.Storage,
    defaultControls: DEFAULT_ASSET_INVENTORY_FILTERS,
    chainingSystem: "HIERARCHICAL",
    spaceId: spaceId,
    ControlGroupRenderer: _public2.ControlGroupRenderer,
    maxControls: 4,
    query: query.query,
    filters: filters,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 5
    }
  });
};
exports.AssetInventoryFilters = AssetInventoryFilters;