"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.LandingLinksIconsCategories = void 0;
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _landing_links_icons = require("./landing_links_icons");
var _constants = require("../constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/packages/navigation/src/landing_links/landing_links_icons_categories.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const useStyles = () => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return {
    horizontalRule: (0, _react2.css)`
      margin-top: ${euiTheme.size.m};
      margin-bottom: ${euiTheme.size.l};
    `
  };
};
const LandingLinksIconsCategories = exports.LandingLinksIconsCategories = /*#__PURE__*/_react.default.memo(function LandingLinksIconsCategories({
  links,
  categories,
  urlState,
  onLinkClick
}) {
  const categoriesLinks = (0, _react.useMemo)(() => {
    const linksById = Object.fromEntries(links.map(link => [link.id, link]));
    return categories.reduce((acc, {
      label,
      linkIds,
      type
    }) => {
      const linksItem = linkIds === null || linkIds === void 0 ? void 0 : linkIds.reduce((linksAcc, linkId) => {
        if (linksById[linkId]) {
          linksAcc.push(linksById[linkId]);
        }
        return linksAcc;
      }, []);
      if (linksItem !== null && linksItem !== void 0 && linksItem.length) {
        acc.push({
          type,
          label,
          links: linksItem
        });
      }
      return acc;
    }, []);
  }, [links, categories]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, categoriesLinks.map(({
    type = _constants.LinkCategoryType.title,
    label,
    links: categoryLinks
  }, index) => /*#__PURE__*/_react.default.createElement("div", {
    key: `${index}_${label}`,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(CategoryHeading, {
    type: type,
    label: label,
    index: index,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_landing_links_icons.LandingLinksIcons, {
    items: categoryLinks,
    urlState: urlState,
    onLinkClick: onLinkClick,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 15
    }
  }))));
});
const CategoryHeading = /*#__PURE__*/_react.default.memo(function CategoryHeading({
  type,
  label,
  index
}) {
  const styles = useStyles();
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, index > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 23
    }
  }), type === _constants.LinkCategoryType.title && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxxs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 15
    }
  }, label)), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    css: styles.horizontalRule,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 13
    }
  })), type === _constants.LinkCategoryType.separator && index > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    css: styles.horizontalRule,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 11
    }
  }));
});

// eslint-disable-next-line import/no-default-export
var _default = exports.default = LandingLinksIconsCategories;