"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSecurityV4Feature = exports.getSecurityV3Feature = exports.getSecurityV2Feature = exports.getSecurityFeature = void 0;
var _kibana_features = require("./v1_features/kibana_features");
var _kibana_sub_features = require("./v1_features/kibana_sub_features");
var _kibana_features2 = require("./v2_features/kibana_features");
var _kibana_sub_features2 = require("./v2_features/kibana_sub_features");
var _kibana_features3 = require("./v3_features/kibana_features");
var _kibana_sub_features3 = require("./v3_features/kibana_sub_features");
var _product_feature_config = require("./product_feature_config");
var _product_feature_config2 = require("./v1_features/product_feature_config");
var _product_feature_config3 = require("./v2_features/product_feature_config");
var _kibana_features4 = require("./v4_features/kibana_features");
var _kibana_sub_features4 = require("./v4_features/kibana_sub_features");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getSecurityFeature = params => ({
  baseKibanaFeature: (0, _kibana_features.getSecurityBaseKibanaFeature)(params),
  baseKibanaSubFeatureIds: (0, _kibana_sub_features.getSecurityBaseKibanaSubFeatureIds)(params),
  subFeaturesMap: (0, _kibana_sub_features.getSecuritySubFeaturesMap)(params),
  productFeatureConfig: _product_feature_config2.securityV1ProductFeaturesConfig
});
exports.getSecurityFeature = getSecurityFeature;
const getSecurityV2Feature = params => ({
  baseKibanaFeature: (0, _kibana_features2.getSecurityV2BaseKibanaFeature)(params),
  baseKibanaSubFeatureIds: (0, _kibana_sub_features2.getSecurityV2BaseKibanaSubFeatureIds)(params),
  subFeaturesMap: (0, _kibana_sub_features2.getSecurityV2SubFeaturesMap)(params),
  productFeatureConfig: _product_feature_config3.securityV2ProductFeaturesConfig
});
exports.getSecurityV2Feature = getSecurityV2Feature;
const getSecurityV3Feature = params => ({
  baseKibanaFeature: (0, _kibana_features3.getSecurityV3BaseKibanaFeature)(params),
  baseKibanaSubFeatureIds: (0, _kibana_sub_features3.getSecurityV3BaseKibanaSubFeatureIds)(params),
  subFeaturesMap: (0, _kibana_sub_features3.getSecurityV3SubFeaturesMap)(params),
  productFeatureConfig: _product_feature_config.securityDefaultProductFeaturesConfig
});
exports.getSecurityV3Feature = getSecurityV3Feature;
const getSecurityV4Feature = params => ({
  baseKibanaFeature: (0, _kibana_features4.getSecurityV4BaseKibanaFeature)(params),
  baseKibanaSubFeatureIds: (0, _kibana_sub_features4.getSecurityV4BaseKibanaSubFeatureIds)(params),
  subFeaturesMap: (0, _kibana_sub_features4.getSecurityV4SubFeaturesMap)(params),
  productFeatureConfig: _product_feature_config.securityDefaultProductFeaturesConfig
});
exports.getSecurityV4Feature = getSecurityV4Feature;