"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RoleMappingsGridPage = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/kibana-react-plugin/public");
var _empty_prompt = require("./empty_prompt");
var _badges = require("../../badges");
var _management_urls = require("../../management_urls");
var _role_table_display = require("../../role_table_display");
var _components = require("../components");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/security/public/management/role_mappings/role_mappings_grid/role_mappings_grid_page.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
class RoleMappingsGridPage extends _react.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "isReadOnlyRoleMapping", record => {
      var _record$metadata;
      return (_record$metadata = record.metadata) === null || _record$metadata === void 0 ? void 0 : _record$metadata._read_only;
    });
    (0, _defineProperty2.default)(this, "renderTable", () => {
      const {
        roleMappings,
        selectedItems,
        loadState
      } = this.state;
      const message = loadState === 'loadingTable' ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.security.management.roleMappings.roleMappingTableLoadingMessage",
        defaultMessage: "Loading role mappings\u2026",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 204,
          columnNumber: 9
        }
      }) : undefined;
      const sorting = {
        sort: {
          field: 'name',
          direction: 'asc'
        }
      };
      const pagination = {
        initialPageSize: 20,
        pageSizeOptions: [10, 20, 50]
      };
      const selection = {
        onSelectionChange: newSelectedItems => {
          this.setState({
            selectedItems: newSelectedItems
          });
        },
        selected: selectedItems
      };
      const search = {
        toolsLeft: selectedItems.length ? /*#__PURE__*/_react.default.createElement(_components.DeleteProvider, {
          roleMappingsAPI: this.props.roleMappingsAPI,
          notifications: this.props.notifications,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 233,
            columnNumber: 9
          }
        }, deleteRoleMappingsPrompt => {
          return /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
            onClick: () => deleteRoleMappingsPrompt(selectedItems, this.onRoleMappingsDeleted),
            color: "danger",
            "data-test-subj": "bulkDeleteActionButton",
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 239,
              columnNumber: 15
            }
          }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.security.management.roleMappings.deleteRoleMappingButton",
            defaultMessage: "Delete {count, plural, one {role mapping} other {role mappings}}",
            values: {
              count: selectedItems.length
            },
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 244,
              columnNumber: 17
            }
          }));
        }) : undefined,
        toolsRight: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
          color: "success",
          iconType: "refresh",
          onClick: () => this.reloadRoleMappings(),
          "data-test-subj": "reloadButton",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 257,
            columnNumber: 9
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.security.management.roleMappings.reloadRoleMappingsButton",
          defaultMessage: "Reload",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 263,
            columnNumber: 11
          }
        })),
        box: {
          incremental: true
        },
        filters: undefined
      };
      return /*#__PURE__*/_react.default.createElement(_components.DeleteProvider, {
        roleMappingsAPI: this.props.roleMappingsAPI,
        notifications: this.props.notifications,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 276,
          columnNumber: 7
        }
      }, deleteRoleMappingPrompt => {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
          items: roleMappings,
          itemId: "name",
          columns: this.getColumnConfig(deleteRoleMappingPrompt),
          search: search,
          sorting: sorting,
          selection: this.props.readOnly ? undefined : {
            selectable: roleMapping => !this.isReadOnlyRoleMapping(roleMapping),
            ...selection
          },
          pagination: pagination,
          loading: loadState === 'loadingTable',
          message: message,
          rowProps: () => {
            return {
              'data-test-subj': 'roleMappingRow'
            };
          },
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 282,
            columnNumber: 13
          }
        });
      });
    });
    (0, _defineProperty2.default)(this, "getColumnConfig", deleteRoleMappingPrompt => {
      const config = [{
        field: 'name',
        name: _i18n.i18n.translate('xpack.security.management.roleMappings.nameColumnName', {
          defaultMessage: 'Name'
        }),
        sortable: true,
        render: roleMappingName => {
          return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, (0, _extends2.default)({}, (0, _public.reactRouterNavigate)(this.props.history, (0, _management_urls.getEditRoleMappingHref)(roleMappingName)), {
            "data-test-subj": "roleMappingName",
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 322,
              columnNumber: 13
            }
          }), roleMappingName);
        }
      }, {
        field: 'roles',
        name: _i18n.i18n.translate('xpack.security.management.roleMappings.rolesColumnName', {
          defaultMessage: 'Roles'
        }),
        sortable: true,
        render: (entry, record) => {
          const {
            roles: assignedRoleNames = [],
            role_templates: roleTemplates = []
          } = record;
          if (roleTemplates.length > 0) {
            return /*#__PURE__*/_react.default.createElement("span", {
              "data-test-subj": "roleMappingRoles",
              __self: this,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 341,
                columnNumber: 15
              }
            }, _i18n.i18n.translate('xpack.security.management.roleMappings.roleTemplates', {
              defaultMessage: '{templateCount, plural, one{# role template} other {# role templates}} defined',
              values: {
                templateCount: roleTemplates.length
              }
            }));
          }
          const roleLinks = assignedRoleNames.map((rolename, index) => {
            var _this$state$roles$fin, _this$state$roles;
            const role = (_this$state$roles$fin = (_this$state$roles = this.state.roles) === null || _this$state$roles === void 0 ? void 0 : _this$state$roles.find(r => r.name === rolename)) !== null && _this$state$roles$fin !== void 0 ? _this$state$roles$fin : rolename;
            return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
              grow: false,
              key: rolename,
              __self: this,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 357,
                columnNumber: 15
              }
            }, /*#__PURE__*/_react.default.createElement(_role_table_display.RoleTableDisplay, {
              role: role,
              navigateToApp: this.props.navigateToApp,
              __self: this,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 358,
                columnNumber: 17
              }
            }));
          });
          return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
            gutterSize: "s",
            "data-test-subj": "roleMappingRoles",
            wrap: true,
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 363,
              columnNumber: 13
            }
          }, roleLinks);
        }
      }, {
        field: 'enabled',
        name: _i18n.i18n.translate('xpack.security.management.roleMappings.enabledColumnName', {
          defaultMessage: 'Enabled'
        }),
        sortable: true,
        render: enabled => {
          if (enabled) {
            return /*#__PURE__*/_react.default.createElement(_badges.EnabledBadge, {
              "data-test-subj": "roleMappingEnabled",
              __self: this,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 377,
                columnNumber: 20
              }
            });
          }
          return /*#__PURE__*/_react.default.createElement(_badges.DisabledBadge, {
            "data-test-subj": "roleMappingEnabled",
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 380,
              columnNumber: 18
            }
          });
        }
      }];
      if (!this.props.readOnly) {
        config.push({
          name: _i18n.i18n.translate('xpack.security.management.roleMappings.actionsColumnName', {
            defaultMessage: 'Actions'
          }),
          width: '108px',
          actions: [{
            isPrimary: true,
            type: 'icon',
            icon: 'copy',
            name: _i18n.i18n.translate('xpack.security.management.roleMappings.actionCloneTooltip', {
              defaultMessage: 'Clone'
            }),
            available: roleMapping => !this.isReadOnlyRoleMapping(roleMapping),
            description: record => _i18n.i18n.translate('xpack.security.management.roleMappings.actionCloneAriaLabel', {
              defaultMessage: `Clone ''{name}''`,
              values: {
                name: record.name
              }
            }),
            href: record => (0, _public.reactRouterNavigate)(this.props.history, (0, _management_urls.getCloneRoleMappingHref)(record.name)).href,
            onClick: (record, event) => (0, _public.reactRouterNavigate)(this.props.history, (0, _management_urls.getCloneRoleMappingHref)(record.name)).onClick(event),
            'data-test-subj': record => `cloneRoleMappingButton-${record.name}`
          }, {
            type: 'icon',
            icon: 'trash',
            color: 'danger',
            name: _i18n.i18n.translate('xpack.security.management.roleMappings.actionDeleteTooltip', {
              defaultMessage: 'Delete'
            }),
            available: roleMapping => !this.isReadOnlyRoleMapping(roleMapping),
            description: record => _i18n.i18n.translate('xpack.security.management.roleMappings.actionDeleteAriaLabel', {
              defaultMessage: `Delete ''{name}''`,
              values: {
                name: record.name
              }
            }),
            'data-test-subj': record => `deleteRoleMappingButton-${record.name}`,
            onClick: record => deleteRoleMappingPrompt([record], this.onRoleMappingsDeleted)
          }, {
            isPrimary: true,
            type: 'icon',
            icon: 'pencil',
            name: _i18n.i18n.translate('xpack.security.management.roleMappings.actionEditTooltip', {
              defaultMessage: 'Edit'
            }),
            available: roleMapping => !this.isReadOnlyRoleMapping(roleMapping),
            description: record => _i18n.i18n.translate('xpack.security.management.roleMappings.actionEditAriaLabel', {
              defaultMessage: `Edit ''{name}''`,
              values: {
                name: record.name
              }
            }),
            'data-test-subj': record => `editRoleMappingButton-${record.name}`,
            href: record => (0, _public.reactRouterNavigate)(this.props.history, (0, _management_urls.getEditRoleMappingHref)(record.name)).href,
            onClick: (record, event) => (0, _public.reactRouterNavigate)(this.props.history, (0, _management_urls.getEditRoleMappingHref)(record.name)).onClick(event)
          }]
        });
      }
      return config;
    });
    (0, _defineProperty2.default)(this, "onRoleMappingsDeleted", roleMappings => {
      if (roleMappings.length) {
        this.reloadRoleMappings();
      }
    });
    (0, _defineProperty2.default)(this, "performInitialLoad", async () => {
      try {
        const [roleMappings, roles] = await Promise.all([this.props.roleMappingsAPI.getRoleMappings(), this.props.rolesAPIClient.getRoles()]);
        this.setState({
          roleMappings,
          roles
        });
      } catch (e) {
        this.setState({
          error: e
        });
      }
      this.setState({
        loadState: 'finished'
      });
    });
    (0, _defineProperty2.default)(this, "reloadRoleMappings", () => {
      this.setState({
        roleMappings: [],
        loadState: 'loadingTable'
      });
      this.loadRoleMappings();
    });
    (0, _defineProperty2.default)(this, "loadRoleMappings", async () => {
      try {
        const roleMappings = await this.props.roleMappingsAPI.getRoleMappings();
        this.setState({
          roleMappings
        });
      } catch (e) {
        this.setState({
          error: e
        });
      }
      this.setState({
        loadState: 'finished'
      });
    });
    this.state = {
      loadState: 'loadingApp',
      roleMappings: null,
      roles: null,
      hasCompatibleRealms: true,
      selectedItems: [],
      error: undefined
    };
  }
  componentDidMount() {
    this.checkPrivileges();
  }
  render() {
    const {
      loadState,
      error,
      roleMappings
    } = this.state;
    if (loadState === 'permissionDenied') {
      return /*#__PURE__*/_react.default.createElement(_components.PermissionDenied, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 96,
          columnNumber: 14
        }
      });
    }
    if (loadState === 'loadingApp') {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiPageSection, {
        alignment: "center",
        grow: true,
        color: "subdued",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 101,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_components.SectionLoading, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 102,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.security.management.roleMappings.loadingRoleMappingsDescription",
        defaultMessage: "Loading role mappings\u2026",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 103,
          columnNumber: 13
        }
      })));
    }
    if (error) {
      const {
        body: {
          error: errorTitle,
          message,
          statusCode
        }
      } = error;
      return /*#__PURE__*/_react.default.createElement(_eui.EuiPageSection, {
        alignment: "center",
        color: "danger",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 118,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
        title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.security.management.roleMappings.loadingRoleMappingsErrorTitle",
          defaultMessage: "Error loading Role mappings",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 121,
            columnNumber: 15
          }
        }),
        color: "danger",
        iconType: "warning",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 119,
          columnNumber: 11
        }
      }, statusCode, ": ", errorTitle, " - ", message));
    }
    if (loadState === 'finished' && roleMappings && roleMappings.length === 0) {
      return /*#__PURE__*/_react.default.createElement(_empty_prompt.EmptyPrompt, {
        history: this.props.history,
        readOnly: this.props.readOnly,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 136,
          columnNumber: 14
        }
      });
    }
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPageHeader, {
      bottomBorder: true,
      pageTitle: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.security.management.roleMappings.roleMappingTitle",
        defaultMessage: "Role Mappings",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 144,
          columnNumber: 13
        }
      }),
      description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.security.management.roleMappings.roleMappingDescription",
        defaultMessage: "Role mappings define which roles are assigned to users from an external identity provider. {learnMoreLink}",
        values: {
          learnMoreLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
            href: this.props.docLinks.links.security.mappingRoles,
            external: true,
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 155,
              columnNumber: 19
            }
          }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.security.management.roleMappings.learnMoreLinkText",
            defaultMessage: "Learn more.",
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 156,
              columnNumber: 21
            }
          }))
        },
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 150,
          columnNumber: 13
        }
      }),
      rightSideItems: this.props.readOnly ? undefined : [/*#__PURE__*/_react.default.createElement(_eui.EuiButton, (0, _extends2.default)({
        fill: true,
        iconType: "plusInCircleFilled",
        "data-test-subj": "createRoleMappingButton"
      }, (0, _public.reactRouterNavigate)(this.props.history, _management_urls.EDIT_ROLE_MAPPING_PATH), {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 169,
          columnNumber: 19
        }
      }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.security.management.roleMappings.createRoleMappingButtonLabel",
        defaultMessage: "Create role mapping",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 175,
          columnNumber: 21
        }
      }))],
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 141,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "l",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 184,
        columnNumber: 9
      }
    }), !this.state.hasCompatibleRealms && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_components.NoCompatibleRealms, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 188,
        columnNumber: 13
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 189,
        columnNumber: 13
      }
    })), this.renderTable());
  }
  async checkPrivileges() {
    try {
      const {
        canReadSecurity,
        hasCompatibleRealms
      } = await this.props.securityFeaturesAPI.checkFeatures();
      this.setState({
        loadState: canReadSecurity ? this.state.loadState : 'permissionDenied',
        hasCompatibleRealms
      });
      if (canReadSecurity) {
        this.performInitialLoad();
      }
    } catch (e) {
      this.setState({
        error: e,
        loadState: 'finished'
      });
    }
  }
}
exports.RoleMappingsGridPage = RoleMappingsGridPage;
(0, _defineProperty2.default)(RoleMappingsGridPage, "defaultProps", {
  readOnly: false
});