"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ShardDetailTree = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _shard_details_tree_node = require("./shard_details_tree_node");
var _shard_details_tree = require("./shard_details_tree.styles");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/searchprofiler/public/application/components/profile_tree/shard_details/shard_details_tree.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ShardDetailTree = ({
  data,
  index,
  shard
}) => {
  const styles = (0, _shard_details_tree.useStyles)();
  const renderOperations = operation => {
    const nextOperation = operation.treeRoot || operation;
    return /*#__PURE__*/_react.default.createElement(_shard_details_tree_node.ShardDetailsTreeNode, {
      shard: shard,
      index: index,
      operation: nextOperation,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 26,
        columnNumber: 12
      }
    });
  };
  return /*#__PURE__*/_react.default.createElement("div", {
    css: styles.panelBody,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 30,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    gutterSize: "none",
    direction: "column",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 31,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 33,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    css: styles.tvHeader,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 34,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    className: "euiTextAlign--left",
    css: styles.cell,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 35,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.searchProfiler.profileTree.header.typeTitle', {
    defaultMessage: 'Type and description'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    css: [styles.cell, styles.time],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 40,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.searchProfiler.profileTree.header.selfTimeTitle', {
    defaultMessage: 'Self time'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    css: [styles.cell, styles.time],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.searchProfiler.profileTree.header.totalTimeTitle', {
    defaultMessage: 'Total time'
  })), /*#__PURE__*/_react.default.createElement("div", {
    css: [styles.cell, styles.percentage],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 9
    }
  }, renderOperations(data))));
};
exports.ShardDetailTree = ShardDetailTree;