"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UnsavedFormProvider = exports.LOCAL_STORAGE_KEY = exports.LOCAL_STORAGE_DEBOUNCE_OPTIONS = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _reactHookForm = require("react-hook-form");
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDomV5Compat = require("react-router-dom-v5-compat");
var _reactHooks = require("@kbn/react-hooks");
var _common = require("../../common");
var _prompt = require("../../common/prompt");
var _use_indices_validation = require("../hooks/use_indices_validation");
var _use_load_fields_by_indices = require("../hooks/use_load_fields_by_indices");
var _types = require("../types");
var _use_llms_models = require("../hooks/use_llms_models");
var _playground_form_resolver = require("../utils/playground_form_resolver");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/search_playground/public/providers/unsaved_form_provider.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const LOCAL_STORAGE_KEY = exports.LOCAL_STORAGE_KEY = 'search_playground_session';
const LOCAL_STORAGE_DEBOUNCE_OPTIONS = exports.LOCAL_STORAGE_DEBOUNCE_OPTIONS = {
  wait: 100,
  maxWait: 500
};
const DEFAULT_FORM_VALUES = {
  prompt: _prompt.DEFAULT_LLM_PROMPT,
  doc_size: _common.DEFAULT_CONTEXT_DOCUMENTS,
  source_fields: {},
  indices: [],
  summarization_model: undefined,
  [_types.PlaygroundFormFields.userElasticsearchQuery]: null
};
const getLocalSession = storage => {
  try {
    const localSessionJSON = storage.getItem(LOCAL_STORAGE_KEY);
    const sessionState = localSessionJSON ? JSON.parse(localSessionJSON) : {};
    return {
      ...DEFAULT_FORM_VALUES,
      ...sessionState
    };
  } catch (e) {
    return DEFAULT_FORM_VALUES;
  }
};
const setLocalSession = (getValues, storage) => {
  const formState = getValues();
  // omit question and search_query from the session state
  const {
    question,
    search_query: _searchQuery,
    ...state
  } = formState;
  storage.setItem(LOCAL_STORAGE_KEY, JSON.stringify(state));
};
const UnsavedFormProvider = ({
  children,
  storage = localStorage
}) => {
  const models = (0, _use_llms_models.useLLMsModels)();
  const [searchParams] = (0, _reactRouterDomV5Compat.useSearchParams)();
  const defaultIndex = (0, _react.useMemo)(() => {
    const index = searchParams.get('default-index');
    return index ? [index] : null;
  }, [searchParams]);
  const sessionState = (0, _react.useMemo)(() => getLocalSession(storage), [storage]);
  const form = (0, _reactHookForm.useForm)({
    defaultValues: {
      ...sessionState,
      indices: [],
      search_query: ''
    },
    resolver: _playground_form_resolver.playgroundFormResolver,
    mode: 'onChange',
    reValidateMode: 'onChange'
  });
  const {
    isValidated: isValidatedIndices,
    validIndices
  } = (0, _use_indices_validation.useIndicesValidation)(defaultIndex || sessionState.indices || []);
  (0, _use_load_fields_by_indices.useLoadFieldsByIndices)({
    watch: form.watch,
    setValue: form.setValue,
    getValues: form.getValues
  });
  const setLocalSessionDebounce = (0, _reactHooks.useDebounceFn)(setLocalSession, LOCAL_STORAGE_DEBOUNCE_OPTIONS);
  (0, _react.useEffect)(() => {
    const subscription = form.watch(_values => setLocalSessionDebounce.run(form.getValues, storage));
    return () => subscription.unsubscribe();
  }, [form, storage, setLocalSessionDebounce]);
  (0, _react.useEffect)(() => {
    if (models.length === 0) return; // don't continue if there are no models
    const defaultModel = models.find(model => !model.disabled);
    const currentModel = form.getValues(_types.PlaygroundFormFields.summarizationModel);
    if (defaultModel && (!currentModel || !models.find(model => currentModel.id === model.id))) {
      form.setValue(_types.PlaygroundFormFields.summarizationModel, defaultModel, {
        shouldValidate: true
      });
    }
  }, [form, models]);
  (0, _react.useEffect)(() => {
    if (isValidatedIndices) {
      form.setValue(_types.PlaygroundFormFields.indices, validIndices);
      form.trigger();
    }
  }, [form, isValidatedIndices, validIndices]);
  return /*#__PURE__*/_react.default.createElement(_reactHookForm.FormProvider, (0, _extends2.default)({}, form, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 10
    }
  }), children);
};
exports.UnsavedFormProvider = UnsavedFormProvider;