"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MessageList = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _types = require("../../types");
var _assistant_message = require("./assistant_message");
var _system_message = require("./system_message");
var _user_message = require("./user_message");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/search_playground/public/components/message_list/message_list.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const mapRoleToMessageComponent = {
  [_types.MessageRole.system]: message => /*#__PURE__*/_react.default.createElement(_system_message.SystemMessage, {
    content: message.content,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 24,
      columnNumber: 47
    }
  }),
  [_types.MessageRole.user]: message => /*#__PURE__*/_react.default.createElement(_user_message.UserMessage, {
    content: message.content,
    createdAt: message.createdAt,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 26,
      columnNumber: 5
    }
  }),
  [_types.MessageRole.assistant]: message => /*#__PURE__*/_react.default.createElement(_assistant_message.AssistantMessage, {
    message: message,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 29,
      columnNumber: 5
    }
  })
};
const MessageList = ({
  messages
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiCommentList, {
  gutterSize: "m",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 34,
    columnNumber: 3
  }
}, messages.map(message => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, {
  key: message.id,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 36,
    columnNumber: 7
  }
}, mapRoleToMessageComponent[message.role](message))));
exports.MessageList = MessageList;