"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CreateIndexUIView = void 0;
var _react = _interopRequireWildcard(require("react"));
var _constants = require("../../analytics/constants");
var _use_usage_tracker = require("../../hooks/use_usage_tracker");
var _indices = require("../../utils/indices");
var _use_create_index = require("../shared/hooks/use_create_index");
var _create_index_form = require("../shared/create_index_form");
var _use_kibana = require("../../hooks/use_kibana");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/search_indices/public/components/start/create_index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const CreateIndexUIView = ({
  userPrivileges,
  formState,
  setFormState
}) => {
  var _userPrivileges$privi;
  const {
    application
  } = (0, _use_kibana.useKibana)().services;
  const [indexNameHasError, setIndexNameHasError] = (0, _react.useState)(false);
  const usageTracker = (0, _use_usage_tracker.useUsageTracker)();
  const {
    createIndex,
    isLoading
  } = (0, _use_create_index.useCreateIndex)();
  const onCreateIndex = (0, _react.useCallback)(e => {
    e.preventDefault();
    if (!(0, _indices.isValidIndexName)(formState.indexName)) {
      return;
    }
    usageTracker.click(_constants.AnalyticsEvents.startCreateIndexClick);
    if (formState.defaultIndexName !== formState.indexName) {
      usageTracker.click(_constants.AnalyticsEvents.startCreateIndexPageModifyIndexName);
    }
    createIndex({
      indexName: formState.indexName
    });
  }, [usageTracker, createIndex, formState.indexName, formState.defaultIndexName]);
  const onIndexNameChange = e => {
    const newIndexName = e.target.value;
    setFormState({
      ...formState,
      indexName: e.target.value
    });
    const invalidIndexName = !(0, _indices.isValidIndexName)(newIndexName);
    if (indexNameHasError !== invalidIndexName) {
      setIndexNameHasError(invalidIndexName);
    }
  };
  const onFileUpload = (0, _react.useCallback)(() => {
    usageTracker.click(_constants.AnalyticsEvents.startFileUploadClick);
    application.navigateToApp('ml', {
      path: 'filedatavisualizer'
    });
  }, [usageTracker, application]);
  return /*#__PURE__*/_react.default.createElement(_create_index_form.CreateIndexForm, {
    indexName: formState.indexName,
    indexNameHasError: indexNameHasError,
    isLoading: isLoading,
    onCreateIndex: onCreateIndex,
    onFileUpload: onFileUpload,
    onIndexNameChange: onIndexNameChange,
    showAPIKeyCreateLabel: (_userPrivileges$privi = userPrivileges === null || userPrivileges === void 0 ? void 0 : userPrivileges.privileges.canCreateApiKeys) !== null && _userPrivileges$privi !== void 0 ? _userPrivileges$privi : false,
    userPrivileges: userPrivileges,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 5
    }
  });
};
exports.CreateIndexUIView = CreateIndexUIView;