"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CreateOrEditModal = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _useDebounce = _interopRequireDefault(require("react-use/lib/useDebounce"));
var _common = require("../../../common");
var _ = require("..");
var _utils = require("./utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/saved_objects_tagging/public/components/edition_modal/create_or_edit_modal.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const CreateOrEditModal = ({
  onClose,
  onSubmit,
  onNameChange,
  validation,
  isValidating,
  setField,
  tag,
  mode
}) => {
  const optionalMessageId = (0, _eui.useGeneratedHtmlId)();
  const editTagModalTitleId = (0, _eui.useGeneratedHtmlId)();
  const ifMounted = (0, _utils.useIfMounted)();
  const [submitting, setSubmitting] = (0, _react.useState)(false);
  const lastNameValue = (0, _react.useRef)(tag.name);

  // we don't want this value to change when the user edits the tag
  // eslint-disable-next-line react-hooks/exhaustive-deps
  const initialTag = (0, _react.useMemo)(() => tag, []);
  const tagHasBeenModified = (0, _react.useMemo)(() => tag.name !== initialTag.name || tag.color !== initialTag.color || tag.description !== initialTag.description, [initialTag, tag]);
  const nameHasBeenModified = tag.name !== lastNameValue.current;
  const setName = (0, _react.useMemo)(() => setField('name'), [setField]);
  const setColor = (0, _react.useMemo)(() => setField('color'), [setField]);
  const setDescription = (0, _react.useMemo)(() => setField('description'), [setField]);
  const isEdit = (0, _react.useMemo)(() => mode === 'edit', [mode]);
  const previewTag = (0, _react.useMemo)(() => {
    return {
      ...tag,
      name: tag.name || 'tag',
      color: (0, _common.validateTagColor)(tag.color) ? '#000000' : tag.color
    };
  }, [tag]);
  const onFormSubmit = (0, _react.useCallback)(async () => {
    setSubmitting(true);
    await onSubmit();
    // onSubmit can close the modal, causing errors in the console when the component tries to setState.
    ifMounted(() => {
      setSubmitting(false);
    });
  }, [ifMounted, onSubmit]);
  (0, _useDebounce.default)(() => {
    onNameChange(tag.name, {
      debounced: true,
      hasBeenModified: nameHasBeenModified
    });
    lastNameValue.current = tag.name;
  }, 300, [tag.name, nameHasBeenModified]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    onClose: onClose,
    css: {
      minWidth: '600px'
    },
    "aria-labelledby": editTagModalTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 116,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 117,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, {
    id: editTagModalTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 9
    }
  }, isEdit ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.savedObjectsTagging.management.editModal.title",
    defaultMessage: "Edit ''{name}'' tag",
    values: {
      name: initialTag.name
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 13
    }
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.savedObjectsTagging.management.createModal.title",
    defaultMessage: "Create tag",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 128,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 135,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    "data-test-subj": "tagModalForm",
    component: "form",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "baseline",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 137,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 3,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 138,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    "data-test-subj": "createModalRow-name",
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.savedObjectsTagging.tagAttributeLabels.name', {
      defaultMessage: 'Name'
    }),
    isInvalid: !!validation.errors.name,
    error: validation.errors.name,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    name: "tag-name",
    fullWidth: true,
    maxLength: _common.tagNameMaxLength,
    value: tag.name,
    onChange: e => setName(e.target.value),
    isLoading: isValidating,
    isInvalid: !!validation.errors.name,
    "data-test-subj": "createModalField-name",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 148,
      columnNumber: 17
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 2,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 160,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    "data-test-subj": "createModalRow-color",
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.savedObjectsTagging.tagAttributeLabels.color', {
      defaultMessage: 'Color'
    }),
    isInvalid: !!validation.errors.color,
    error: validation.errors.color,
    labelAppend: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      onClick: () => setColor((0, _utils.getRandomColor)()),
      size: "xs",
      css: {
        height: '18px',
        fontSize: '0.75rem'
      },
      "aria-label": _i18n.i18n.translate('xpack.savedObjectsTagging.management.createModal.color.randomizeAriaLabel', {
        defaultMessage: 'Randomize tag color'
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 170,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.savedObjectsTagging.management.createModal.color.randomize",
      defaultMessage: "Randomize",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 181,
        columnNumber: 21
      }
    })),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 161,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiColorPicker, {
    color: tag.color,
    fullWidth: true,
    onChange: text => setColor(text),
    format: "hex",
    isInvalid: !!validation.errors.color,
    "data-test-subj": "createModalField-color",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 188,
      columnNumber: 17
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 199,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    "data-test-subj": "createModalRow-description",
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.savedObjectsTagging.tagAttributeLabels.description', {
      defaultMessage: 'Description'
    }),
    labelAppend: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      color: "subdued",
      id: optionalMessageId,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 207,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.savedObjectsTagging.management.optionalFieldText",
      defaultMessage: "Optional",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 208,
        columnNumber: 17
      }
    })),
    isInvalid: !!validation.errors.description,
    error: validation.errors.description,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 200,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextArea, {
    name: "description",
    value: tag.description,
    maxLength: _common.tagDescriptionMaxLength,
    onChange: e => setDescription(e.target.value),
    "data-test-subj": "createModalField-description",
    resize: "none",
    fullWidth: true,
    compressed: true,
    isInvalid: !!validation.errors.description,
    "aria-describedby": optionalMessageId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 217,
      columnNumber: 13
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 232,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "baseline",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 233,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 234,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    justifyContent: "spaceBetween",
    alignItems: "baseline",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 235,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 236,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 237,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.savedObjectsTagging.management.tagPreviewText",
    defaultMessage: "Preview",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 238,
      columnNumber: 19
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 244,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_.TagBadge, {
    tag: previewTag,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 245,
      columnNumber: 17
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 249,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "baseline",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 250,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 251,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: onClose,
    "data-test-subj": "createModalCancelButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 252,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.savedObjectsTagging.management.createModal.closeButtonText",
    defaultMessage: "Cancel",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 253,
      columnNumber: 19
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 259,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    iconType: isEdit ? 'save' : 'tag',
    color: "primary",
    fill: true,
    "data-test-subj": "createModalConfirmButton",
    onClick: onFormSubmit,
    isLoading: submitting,
    isDisabled: submitting || isEdit && !tagHasBeenModified,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 260,
      columnNumber: 17
    }
  }, isEdit ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.savedObjectsTagging.management.createModal.updateTagButtonLabel",
    defaultMessage: "Save changes",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 270,
      columnNumber: 21
    }
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.savedObjectsTagging.management.createModal.createTagButtonLabel",
    defaultMessage: "Create tag",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 275,
      columnNumber: 21
    }
  }))))))));
};
exports.CreateOrEditModal = CreateOrEditModal;