"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Header = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/saved_objects_management/public/management_section/objects_table/components/header.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const Header = ({
  onExportAll,
  onImport,
  onRefresh,
  filteredCount
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiPageHeader, {
  pageTitle: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "savedObjectsManagement.objectsTable.header.savedObjectsTitle",
    defaultMessage: "Saved Objects",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 27,
      columnNumber: 7
    }
  }),
  description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "savedObjectsManagement.objectsTable.howToDeleteSavedObjectsDescription",
    defaultMessage: "Manage and share your saved objects. To edit the underlying data of an object, go to its associated application.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 33,
      columnNumber: 7
    }
  }),
  bottomBorder: true,
  rightSideItems: [/*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "s",
    iconType: "exportAction",
    "data-test-subj": "exportAllObjects",
    onClick: onExportAll,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 40,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "savedObjectsManagement.objectsTable.header.exportButtonLabel",
    defaultMessage: "Export {filteredCount, plural, one{# object} other {# objects}}",
    values: {
      filteredCount
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "s",
    iconType: "importAction",
    "data-test-subj": "importObjects",
    onClick: onImport,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "savedObjectsManagement.objectsTable.header.importButtonLabel",
    defaultMessage: "Import",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "s",
    iconType: "refresh",
    onClick: onRefresh,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "savedObjectsManagement.objectsTable.header.refreshButtonLabel",
    defaultMessage: "Refresh",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 9
    }
  }))],
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 25,
    columnNumber: 3
  }
});
exports.Header = Header;