"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HostBreakdown = HostBreakdown;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _use_async = require("../../../hooks/use_async");
var _async_component = require("../../../components/async_component");
var _use_profiling_dependencies = require("../../../components/contexts/profiling_dependencies/use_profiling_dependencies");
var _use_profiling_params = require("../../../hooks/use_profiling_params");
var _use_time_range = require("../../../hooks/use_time_range");
var _use_time_range_async = require("../../../hooks/use_time_range_async");
var _hosts_table = require("./hosts_table");
var _host_breakdown_chart = require("./host_breakdown_chart");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/profiling/public/views/storage_explorer/host_breakdown/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function HostBreakdown({
  hasDistinctProbabilisticValues,
  onReady
}) {
  var _storageExplorerHostD, _storageExplorerHostD2;
  const {
    query
  } = (0, _use_profiling_params.useProfilingParams)('/storage-explorer');
  const {
    rangeFrom,
    rangeTo,
    kuery,
    indexLifecyclePhase
  } = query;
  const timeRange = (0, _use_time_range.useTimeRange)({
    rangeFrom,
    rangeTo
  });
  const {
    services: {
      fetchStorageExplorerHostStorageDetails
    }
  } = (0, _use_profiling_dependencies.useProfilingDependencies)();
  const storageExplorerHostDetailsState = (0, _use_time_range_async.useTimeRangeAsync)(({
    http
  }) => {
    return fetchStorageExplorerHostStorageDetails({
      http,
      timeFrom: timeRange.inSeconds.start,
      timeTo: timeRange.inSeconds.end,
      kuery,
      indexLifecyclePhase
    });
  }, [fetchStorageExplorerHostStorageDetails, timeRange.inSeconds.start, timeRange.inSeconds.end, kuery, indexLifecyclePhase]);
  (0, _react.useEffect)(() => {
    if (storageExplorerHostDetailsState.status === _use_async.AsyncStatus.Settled) {
      onReady();
    }
  }, [storageExplorerHostDetailsState.status, onReady]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('xpack.profiling.storageExplorer.hostBreakdown.title', {
    defaultMessage: 'Host agent breakdown'
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    content: _i18n.i18n.translate('xpack.profiling.storageExplorer.hostBreakdown.title.hint', {
      defaultMessage: 'This graph shows the combined values of Universal Profiling samples and metrics. host.name[host.id].'
    }),
    type: "question",
    iconProps: {
      style: {
        marginLeft: 4
      }
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    hasBorder: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_async_component.AsyncComponent, (0, _extends2.default)({
    size: "xl"
  }, storageExplorerHostDetailsState, {
    style: {
      height: 400
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_host_breakdown_chart.HostBreakdownChart, {
    data: (_storageExplorerHostD = storageExplorerHostDetailsState.data) === null || _storageExplorerHostD === void 0 ? void 0 : _storageExplorerHostD.hostDetailsTimeseries,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_hosts_table.HostsTable, {
    data: (_storageExplorerHostD2 = storageExplorerHostDetailsState.data) === null || _storageExplorerHostD2 === void 0 ? void 0 : _storageExplorerHostD2.hostDetails,
    hasDistinctProbabilisticValues: hasDistinctProbabilisticValues,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 15
    }
  }))))));
}