"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DifferentialFlameGraphSearchPanel = DifferentialFlameGraphSearchPanel;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _use_profiling_params = require("../../../hooks/use_profiling_params");
var _use_profiling_router = require("../../../hooks/use_profiling_router");
var _use_profiling_route_path = require("../../../hooks/use_profiling_route_path");
var _primary_and_comparison_search_bar = require("../../../components/primary_and_comparison_search_bar");
var _normalization_menu = require("../../../components/normalization_menu");
var _differential_comparison_mode = require("../../../components/differential_comparison_mode");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/profiling/public/views/flamegraphs/differential_flamegraphs/differential_flame_graph_search_panel.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function DifferentialFlameGraphSearchPanel({
  comparisonMode,
  normalizationMode,
  normalizationOptions
}) {
  const {
    path,
    query
  } = (0, _use_profiling_params.useProfilingParams)('/flamegraphs/*');
  const routePath = (0, _use_profiling_route_path.useProfilingRoutePath)();
  const profilingRouter = (0, _use_profiling_router.useProfilingRouter)();
  function onChangeComparisonMode(nextComparisonMode) {
    if (!('comparisonRangeFrom' in query)) {
      return;
    }
    profilingRouter.push(routePath, {
      path,
      query: {
        ...query,
        ...(nextComparisonMode === _normalization_menu.ComparisonMode.Absolute ? {
          comparisonMode: _normalization_menu.ComparisonMode.Absolute,
          normalizationMode
        } : {
          comparisonMode: _normalization_menu.ComparisonMode.Relative
        })
      }
    });
  }
  function onChangeNormalizationMode(nextNormalizationMode, options) {
    profilingRouter.push(routePath, {
      path: routePath,
      query: nextNormalizationMode === _normalization_menu.NormalizationMode.Scale ? {
        ...query,
        baseline: options.baselineScale,
        comparison: options.comparisonScale,
        normalizationMode: nextNormalizationMode
      } : {
        ...query,
        normalizationMode: nextNormalizationMode
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    color: "subdued",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_primary_and_comparison_search_bar.PrimaryAndComparisonSearchBar, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_differential_comparison_mode.DifferentialComparisonMode, {
    comparisonMode: comparisonMode,
    onChange: onChangeComparisonMode,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 9
    }
  }), comparisonMode === _normalization_menu.ComparisonMode.Absolute && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "m",
    alignItems: "center",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_normalization_menu.NormalizationMenu, {
    onChange: onChangeNormalizationMode,
    mode: normalizationMode,
    options: normalizationOptions,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 17
    }
  }))))));
}