"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RouterErrorBoundary = RouterErrorBoundary;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _typedReactRouterConfig = require("@kbn/typed-react-router-config");
var _public = require("@kbn/kibana-react-plugin/public");
var _react = _interopRequireDefault(require("react"));
var _sharedUxPromptNotFound = require("@kbn/shared-ux-prompt-not-found");
var _reactRouterDom = require("react-router-dom");
var _i18n = require("@kbn/i18n");
var _sharedUxErrorBoundary = require("@kbn/shared-ux-error-boundary");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/profiling/public/routing/router_error_boundary.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function RouterErrorBoundary({
  children
}) {
  const location = (0, _reactRouterDom.useLocation)();
  return /*#__PURE__*/_react.default.createElement(ErrorBoundary, {
    key: location.pathname,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 18,
      columnNumber: 10
    }
  }, children);
}
class ErrorBoundary extends _react.default.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "state", {
      error: undefined
    });
  }
  static getDerivedStateFromError(error) {
    return {
      error
    };
  }
  render() {
    if (this.state.error) {
      return /*#__PURE__*/_react.default.createElement(ErrorWithTemplate, {
        error: this.state.error,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 32,
          columnNumber: 14
        }
      });
    }
    return this.props.children;
  }
}
const pageHeader = {
  pageTitle: _i18n.i18n.translate('xpack.profiling.universalProfiling', {
    defaultMessage: 'Universal Profiling'
  })
};
function ErrorWithTemplate({
  error
}) {
  const {
    services
  } = (0, _public.useKibana)();
  const {
    observabilityShared
  } = services;
  const ObservabilityPageTemplate = observabilityShared.navigation.PageTemplate;
  if (error instanceof _typedReactRouterConfig.NotFoundRouteException) {
    return /*#__PURE__*/_react.default.createElement(ObservabilityPageTemplate, {
      pageHeader: pageHeader,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 53,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_sharedUxPromptNotFound.NotFoundPrompt, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 54,
        columnNumber: 9
      }
    }));
  }
  return /*#__PURE__*/_react.default.createElement(ObservabilityPageTemplate, {
    pageHeader: pageHeader,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_sharedUxErrorBoundary.KibanaErrorBoundary, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(DummyComponent, {
    error: error,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 9
    }
  })));
}
function DummyComponent({
  error
}) {
  throw error;
}