"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StackFrameSummary = StackFrameSummary;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _profilingUtils = require("@kbn/profiling-utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/profiling/public/components/stack_frame_summary/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function CalleeFunctionText({
  calleeFunctionName
}) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    style: {
      fontWeight: 'bold',
      overflowWrap: 'anywhere'
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 19,
      columnNumber: 5
    }
  }, calleeFunctionName);
}
function StackFrameSummary({
  frame,
  onFrameClick
}) {
  const calleeFunctionName = (0, _profilingUtils.getCalleeFunction)(frame);
  function handleOnClick() {
    if (onFrameClick) {
      onFrameClick(calleeFunctionName);
    }
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 35,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 37,
      columnNumber: 9
    }
  }, onFrameClick ? /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "profilingStackFrameSummaryLink",
    onClick: handleOnClick,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(CalleeFunctionText, {
    calleeFunctionName: calleeFunctionName,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 40,
      columnNumber: 15
    }
  })) : /*#__PURE__*/_react.default.createElement(CalleeFunctionText, {
    calleeFunctionName: calleeFunctionName,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    style: {
      overflowWrap: 'anywhere'
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 9
    }
  }, (0, _profilingUtils.getCalleeSource)(frame) || '‎')));
}