"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OsqueryApp = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _public = require("@kbn/kibana-react-plugin/public");
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _rxjs = require("rxjs");
var _default = require("./layouts/default");
var _routes = require("../routes");
var _hooks = require("../common/hooks");
var _empty_state = require("./empty_state");
var _main_navigation = require("./main_navigation");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/osquery/public/components/app.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const OsqueryAppComponent = () => {
  const {
    customBranding
  } = (0, _public.useKibana)().services;
  const {
    data: osqueryIntegration,
    isFetched
  } = (0, _hooks.useOsqueryIntegrationStatus)();
  const hasCustomBranding = (0, _useObservable.default)((customBranding === null || customBranding === void 0 ? void 0 : customBranding.hasCustomBranding$) || (0, _rxjs.of)(false), false);
  if (!isFetched) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPage, {
      paddingSize: "none",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 32,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiPageBody, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 33,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiPageSection, {
      paddingSize: "none",
      color: "subdued",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 34,
        columnNumber: 11
      }
    }, hasCustomBranding ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "xxl",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 36,
        columnNumber: 15
      }
    }) : /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingElastic, {
      size: "xxl",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 38,
        columnNumber: 15
      }
    }))));
  }
  if (isFetched && (osqueryIntegration === null || osqueryIntegration === void 0 ? void 0 : osqueryIntegration.install_status) !== 'installed') {
    return /*#__PURE__*/_react.default.createElement(_empty_state.OsqueryAppEmptyState, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 47,
        columnNumber: 12
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement("div", {
    css: _default.containerCss,
    id: "osquery-app",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    css: _default.wrapperCss,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_main_navigation.MainNavigation, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_routes.OsqueryAppRoutes, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 9
    }
  })));
};
const OsqueryApp = exports.OsqueryApp = /*#__PURE__*/_react.default.memo(OsqueryAppComponent);