/*! Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one or more contributor license agreements.
 * Licensed under the Elastic License 2.0; you may not use this file except in compliance with the Elastic License 2.0. */(()=>{var e,t={8597:(e,t,r)=>{"use strict";r.d(t,{n7:()=>s});const s="agentBuilder:enabled"},2787:(e,t,r)=>{"use strict";r.d(t,{l:()=>n,r:()=>s});const s="/api/agent_builder",n="/internal/agent_builder"},7294:(e,t,r)=>{"use strict";r.d(t,{O:()=>n});var s=r(8915);const n=new class AgentBuilderDocLinks{constructor(){(0,s.default)(this,"agentBuilder",""),(0,s.default)(this,"getStarted",""),(0,s.default)(this,"models",""),(0,s.default)(this,"chat",""),(0,s.default)(this,"agentBuilderAgents",""),(0,s.default)(this,"tools",""),(0,s.default)(this,"programmaticAccess",""),(0,s.default)(this,"kibanaApi",""),(0,s.default)(this,"mcpServer",""),(0,s.default)(this,"a2aServer",""),(0,s.default)(this,"limitationsKnownIssues","")}setDocLinks(e){this.agentBuilder=e.agentBuilder.agentBuilder,this.getStarted=e.agentBuilder.getStarted,this.models=e.agentBuilder.models,this.chat=e.agentBuilder.chat,this.agentBuilderAgents=e.agentBuilder.agentBuilderAgents,this.tools=e.agentBuilder.tools,this.programmaticAccess=e.agentBuilder.programmaticAccess,this.kibanaApi=e.agentBuilder.kibanaApi,this.mcpServer=e.agentBuilder.mcpServer,this.a2aServer=e.agentBuilder.a2aServer,this.limitationsKnownIssues=e.agentBuilder.limitationsKnownIssues}}},4045:(e,t,r)=>{"use strict";r.d(t,{m:()=>s});const s={ONECHAT_CONVERSE_ERROR:"onechat_converse_error"}},9979:(e,t,r)=>{"use strict";r.d(t,{B4:()=>i,Ek:()=>c,Ky:()=>n,TS:()=>o,hB:()=>l,z2:()=>a});var s=r(5008);const n="agentBuilder",a="agent_builder",i="/app/agent_builder",o=s.i18n.translate("xpack.onechat.app.fullTitle",{defaultMessage:"Agent Builder"}),c=s.i18n.translate("xpack.onechat.app.shortTitle",{defaultMessage:"Agents"}),l={show:"show",showManagement:"showManagement",manageTools:"manageTools",manageAgents:"manageAgents"}},1862:(e,t,r)=>{"use strict";r.r(t),r.d(t,{plugin:()=>w});var s=r(8915),n=r(8597),a=r(7294),i=r(9979);class AgentBuilderLocatorDefinition{constructor(){(0,s.default)(this,"getLocation",(async()=>({app:i.z2,path:"",state:{}}))),(0,s.default)(this,"id","AGENT_BUILDER_LOCATOR_ID")}}var o=r(5008);const c=Object.freeze({kibana:{id:"kibana",label:o.i18n.translate("core.ui.kibanaNavList.label",{defaultMessage:"Analytics"}),euiIconType:"logoKibana",order:1e3},enterpriseSearch:{id:"enterpriseSearch",label:o.i18n.translate("core.ui.searchNavList.label",{defaultMessage:"Elasticsearch"}),order:2e3,euiIconType:"logoElasticsearch"},observability:{id:"observability",label:o.i18n.translate("core.ui.observabilityNavList.label",{defaultMessage:"Observability"}),euiIconType:"logoObservability",order:3e3},security:{id:"securitySolution",label:o.i18n.translate("core.ui.securityNavList.label",{defaultMessage:"Security"}),order:4e3,euiIconType:"logoSecurity"},chat:{id:"chat",label:o.i18n.translate("core.ui.chatNavList.label",{defaultMessage:"Workchat"}),order:4500,euiIconType:"logoElasticsearch"},management:{id:"management",label:o.i18n.translate("core.ui.managementNavList.label",{defaultMessage:"Management"}),order:5e3,euiIconType:"managementApp"}});var l=r(4045);const u=__kbnSharedDeps__.Rxjs;class AgentBuilderAccessChecker{constructor({licensing:e,inference:t}){(0,s.default)(this,"licensing",void 0),(0,s.default)(this,"inference",void 0),(0,s.default)(this,"access",null),this.licensing=e,this.inference=t}async hasRequiredLicense(){const e=await(0,u.firstValueFrom)(this.licensing.license$);return e.hasAtLeast("enterprise")&&e.isActive}async hasLlmConnector(){return(await this.inference.getConnectors()).length>0}async initAccess(){if(null!==this.access)return;const e={hasRequiredLicense:this.hasRequiredLicense(),hasLlmConnector:this.hasLlmConnector()};try{this.access=await(async e=>{const t=await Promise.all(Object.entries(e).map((async([e,t])=>[e,await t])));return Object.fromEntries(t)})(e)}catch(e){throw new Error("Unable to determine Agent Builder access",{cause:e})}}getAccess(){if(!this.access)throw new Error("Agent Builder access was not initialized");return this.access}}var d=r(2787);class AgentService{constructor({http:e}){(0,s.default)(this,"http",void 0),this.http=e}async list(e){return(await this.http.get(`${d.r}/agents`)).results}async get(e){return await this.http.get(`${d.r}/agents/${e}`)}async create(e){return await this.http.post(`${d.r}/agents`,{body:JSON.stringify(e)})}async update(e,t){return await this.http.put(`${d.r}/agents/${e}`,{body:JSON.stringify(t)})}async delete(e){return await this.http.delete(`${d.r}/agents/${e}`)}}var h=Object.defineProperty,p=(e,t,r)=>((e,t,r)=>t in e?h(e,t,{enumerable:!0,configurable:!0,writable:!0,value:r}):e[t]=r)(e,"symbol"!=typeof t?t+"":t,r);class ParseError extends Error{constructor(e,t){super(e),p(this,"type"),p(this,"field"),p(this,"value"),p(this,"line"),this.name="ParseError",this.type=t.type,this.field=t.field,this.value=t.value,this.line=t.line}}function g(e){}let v=function(e){return e.error="error",e.data="data",e}({}),_=function(e){return e.internalError="internalError",e.requestError="requestError",e}({});class ServerSentEventError extends Error{constructor(e,t,r){super(t),this.code=e,this.meta=r}get status(){if("object"==typeof this.meta&&this.meta.status)return this.meta.status}toJSON(){return{type:v.error,error:{code:this.code,message:this.message,meta:this.meta}}}}function b(e=o.i18n.translate("sse.internalError",{defaultMessage:"An internal error occurred"})){return new ServerSentEventError(_.internalError,e,{})}function f(){return(0,u.switchMap)((e=>function(e){const t=e.response,r=null==t?void 0:t.body;return r?new u.Observable((e=>{const t=function(e){const{onEvent:t=g,onError:r=g,onRetry:s=g,onComment:n}=e;let a,i="",o=!0,c="",l="";function u(e){if(""===e)return c.length>0&&t({id:a,event:l||void 0,data:c.endsWith("\n")?c.slice(0,-1):c}),a=void 0,c="",void(l="");if(e.startsWith(":"))return void(n&&n(e.slice(e.startsWith(": ")?2:1)));const r=e.indexOf(":");if(-1===r)d(e,"",e);else{const t=e.slice(0,r),s=" "===e[r+1]?2:1;d(t,e.slice(r+s),e)}}function d(e,t,n){switch(e){case"event":l=t;break;case"data":c=`${c}${t}\n`;break;case"id":a=t.includes("\0")?void 0:t;break;case"retry":/^\d+$/.test(t)?s(parseInt(t,10)):r(new ParseError(`Invalid \`retry\` value: "${t}"`,{type:"invalid-retry",value:t,line:n}));break;default:r(new ParseError(`Unknown field "${e.length>20?`${e.slice(0,20)}…`:e}"`,{type:"unknown-field",field:e,value:t,line:n}))}}return{feed:function(e){const t=o?e.replace(/^\xEF\xBB\xBF/,""):e,[r,s]=function(e){const t=[];let r="";const s=e.length;for(let n=0;n<s;n++){const s=e[n];"\r"===s&&"\n"===e[n+1]?(t.push(r),r="",n++):"\r"===s||"\n"===s?(t.push(r),r=""):r+=s}return[t,r]}(`${i}${t}`);for(const e of r)u(e);i=s,o=!1},reset:function(e={}){i&&e.consume&&u(i),a=void 0,c="",l="",i=""}}}({onEvent:t=>{try{const r=JSON.parse(t.data);if("error"===t.event){const t=r;e.error(new ServerSentEventError(t.error.code,t.error.message,t.error.meta))}else e.next({type:t.event||"event",...r})}catch(t){e.error(b("Failed to parse JSON"))}}});(async()=>{const e=r.getReader(),s=new TextDecoder,n=({done:r,value:a})=>r?Promise.resolve():(t.feed(s.decode(a,{stream:!0})),e.read().then(n));return e.read().then(n)})().then((()=>{e.complete()})).catch((t=>{e.error(t)}))})):(0,u.throwError)((()=>{throw b("No readable stream found in response")}))}(e)))}const m=ServerSentEventError;function y(){return(0,u.catchError)((e=>e instanceof ServerSentEventError?(0,u.throwError)((()=>{return t=e.code,r=e.message,s=e.meta,new m(t,r,null!=s?s:{});var t,r,s})):(0,u.throwError)((()=>e))))}class ChatService{constructor({http:e}){(0,s.default)(this,"http",void 0),this.http=e}chat(e){var t;const r={input:e.input,agent_id:e.agentId,conversation_id:e.conversationId,connector_id:e.connectorId,capabilities:null!==(t=e.capabilities)&&void 0!==t?t:{visualizations:!0}};return(0,u.defer)((()=>this.http.post(`${d.r}/converse/async`,{signal:e.signal,asResponse:!0,rawResponse:!0,body:JSON.stringify(r)}))).pipe(f(),y())}}class ConversationsService{constructor({http:e}){(0,s.default)(this,"http",void 0),this.http=e}async list({agentId:e}){return(await this.http.get(`${d.r}/conversations`,{query:{agent_id:e}})).results}async get({conversationId:e}){return await this.http.get(`${d.r}/conversations/${e}`)}async delete({conversationId:e}){return await this.http.delete(`${d.r}/conversations/${e}`)}}class NavigationService{constructor(e){(0,s.default)(this,"locators",void 0),this.locators=e}hasLicenseManagentLocator(){return Boolean(this.locators.licenseManagement)}navigateToLicenseManagementDashboard(){var e;null===(e=this.locators.licenseManagement)||void 0===e||e.navigateSync({page:"dashboard"})}navigateToLlmConnectorsManagement(){this.locators.management.navigateSync({sectionId:"insightsAndAlerting",appId:"triggersActionsConnectors/connectors"})}}class ToolsService{constructor({http:e}){(0,s.default)(this,"http",void 0),this.http=e}async list(){const{results:e}=await this.http.get(`${d.r}/tools`,{});return e}async get({toolId:e}){return await this.http.get(`${d.r}/tools/${e}`,{})}async delete({toolId:e}){return await this.http.delete(`${d.r}/tools/${e}`,{})}async create(e){return await this.http.post(`${d.r}/tools`,{body:JSON.stringify(e)})}async update(e,t){return await this.http.put(`${d.r}/tools/${e}`,{body:JSON.stringify(t)})}async execute({toolId:e,toolParams:t,connectorId:r}){return await this.http.post(`${d.r}/tools/_execute`,{body:JSON.stringify({tool_id:e,tool_params:t,connector_id:r})})}async bulkDelete(e){return await this.http.post(`${d.l}/tools/_bulk_delete`,{body:JSON.stringify({ids:e})})}async resolveSearchSources({pattern:e}){return await this.http.get(`${d.l}/tools/_resolve_search_sources`,{query:{pattern:e}})}async getWorkflow(e){return await this.http.get(`${d.l}/tools/_get_workflow/${e}`)}async listWorkflows({page:e,limit:t}){return await this.http.get(`${d.l}/tools/_list_workflows`,{query:{page:e,limit:t}})}async getToolTypes(){return(await this.http.get(`${d.l}/tools/_types_info`)).toolTypes}}const S=({toolsService:e})=>({get:async t=>e.get({toolId:t}),list:async()=>e.list(),execute:async({toolId:t,toolParams:r,connectorId:s})=>e.execute({toolId:t,toolParams:r,connectorId:s})});class OnechatPlugin{constructor(e){(0,s.default)(this,"logger",void 0),(0,s.default)(this,"internalServices",void 0),(0,s.default)(this,"setupServices",void 0),this.logger=e.logger.get()}setup(e,t){var s;const a=e.uiSettings.get(n.n7,!1),u=new NavigationService({management:t.management.locator,licenseManagement:null===(s=t.licenseManagement)||void 0===s?void 0:s.locator});this.setupServices={navigationService:u},a&&((({core:e,getServices:t})=>{e.application.register({id:i.z2,appRoute:i.B4,category:c.enterpriseSearch,title:i.Ek,euiIconType:"logoElasticsearch",visibleIn:["sideNav","globalSearch"],deepLinks:[{id:"conversations",path:"/conversations",title:o.i18n.translate("xpack.onechat.chat.conversationsTitle",{defaultMessage:"Agent Chat"})},{id:"tools",path:"/tools",title:o.i18n.translate("xpack.onechat.tools.title",{defaultMessage:"Tools"})},{id:"agents",path:"/agents",title:o.i18n.translate("xpack.onechat.agents.title",{defaultMessage:"Agents"})}],async mount({element:s,history:n}){const{mountApp:a}=await r.e(473).then(r.bind(r,9999)),[o,c]=await e.getStartServices();return o.chrome.docTitle.change(i.TS),a({core:o,services:t(),element:s,history:n,plugins:c})}})})({core:e,getServices:()=>{if(!this.internalServices)throw new Error("getServices called before plugin start");return this.internalServices}}),(({analytics:e})=>{e.registerEventType({eventType:l.m.ONECHAT_CONVERSE_ERROR,schema:{error_type:{type:"keyword",_meta:{description:"The type/name of the error that occurred during conversation"}},error_message:{type:"text",_meta:{description:"The error message describing what went wrong"}},error_stack:{type:"text",_meta:{description:"The error stack trace if available",optional:!0}},conversation_id:{type:"keyword",_meta:{description:"The ID of the conversation where the error occurred",optional:!0}},agent_id:{type:"keyword",_meta:{description:"The ID of the agent involved in the conversation",optional:!0}},connector_id:{type:"keyword",_meta:{description:"The ID of the connector used for the conversation",optional:!0}}}})})({analytics:e.analytics}),t.share.url.locators.create(new AgentBuilderLocatorDefinition));try{e.getStartServices().then((([s])=>{const{capabilities:n}=s.application;n[i.Ky][i.hB.showManagement]&&(({core:e,management:t})=>{t.sections.section.ai.registerApp({id:"agentBuilder",title:i.TS,order:3,mount:async t=>{const{mountManagementSection:s}=await r.e(964).then(r.bind(r,7964));return s({core:e,mountParams:t})}})})({core:e,management:t.management})}))}catch(e){this.logger.error("Error registering Agent Builder management section",e)}return{}}start(e,t){const{http:r}=e,{licensing:s,inference:n}=t;a.O.setDocLinks(e.docLinks.links);const i=new AgentService({http:r}),o=new ChatService({http:r}),c=new ConversationsService({http:r}),l=new ToolsService({http:r}),u=new AgentBuilderAccessChecker({licensing:s,inference:n});if(!this.setupServices)throw new Error("plugin start called before plugin setup");const{navigationService:d}=this.setupServices;return this.internalServices={agentService:i,chatService:o,conversationsService:c,navigationService:d,toolsService:l,startDependencies:t,accessChecker:u},{tools:S({toolsService:l})}}}const w=e=>new OnechatPlugin(e)},6765:(e,t,r)=>{r.p=window.__kbnPublicPath__.onechat},104:(e,t,r)=>{r.r(t);var s=__kbnBundles__.get("plugin/esql/public");Object.defineProperties(t,Object.getOwnPropertyDescriptors(s))},409:(e,t,r)=>{r.r(t);var s=__kbnBundles__.get("plugin/kibanaReact/public");Object.defineProperties(t,Object.getOwnPropertyDescriptors(s))},1215:(e,t,r)=>{r.r(t);var s=__kbnBundles__.get("plugin/kibanaUtils/public");Object.defineProperties(t,Object.getOwnPropertyDescriptors(s))},1254:(e,t,r)=>{r.r(t);var s=__kbnBundles__.get("plugin/spaces/common");Object.defineProperties(t,Object.getOwnPropertyDescriptors(s))},8915:(e,t,r)=>{e.exports=r(2497)(67493)},5927:e=>{"use strict";e.exports=__kbnSharedDeps__.Classnames},1319:e=>{"use strict";e.exports=__kbnSharedDeps__.ElasticEui},6791:e=>{"use strict";e.exports=__kbnSharedDeps__.EmotionReact},6351:e=>{"use strict";e.exports=__kbnSharedDeps__.Immer},9424:e=>{"use strict";e.exports=__kbnSharedDeps__.KbnCodeEditor},9551:e=>{"use strict";e.exports=__kbnSharedDeps__.KbnCryptoBrowser},1991:e=>{"use strict";e.exports=__kbnSharedDeps__.KbnEsqlAst},5008:e=>{"use strict";e.exports=__kbnSharedDeps__.KbnI18n},5879:e=>{"use strict";e.exports=__kbnSharedDeps__.KbnI18nReact},911:e=>{"use strict";e.exports=__kbnSharedDeps__.KbnMonaco},3999:e=>{"use strict";e.exports=__kbnSharedDeps__.KbnReactKibanaContextTheme},193:e=>{"use strict";e.exports=__kbnSharedDeps__.KbnSharedUxRouter},770:e=>{"use strict";e.exports=__kbnSharedDeps__.Lodash},1783:e=>{"use strict";e.exports=__kbnSharedDeps__.Moment},4286:e=>{"use strict";e.exports=__kbnSharedDeps__.React},2874:e=>{"use strict";e.exports=__kbnSharedDeps__.ReactDom},3530:e=>{"use strict";e.exports=__kbnSharedDeps__.ReactQuery},1493:e=>{"use strict";e.exports=__kbnSharedDeps__.ReactRouterDom},8102:e=>{"use strict";e.exports=__kbnSharedDeps__.ReactRouterDomV5Compat},6524:e=>{"use strict";e.exports=__kbnSharedDeps__.ReactUse.useAsync},7064:e=>{"use strict";e.exports=__kbnSharedDeps__.ReactUse.useLocalStorage},5079:e=>{"use strict";e.exports=__kbnSharedDeps__.SaferLodashSet},4322:e=>{"use strict";e.exports=__kbnSharedDeps__.TsLib},9472:e=>{"use strict";e.exports=__kbnSharedDeps__.Uuid},2497:e=>{"use strict";e.exports=__kbnSharedDeps_npm__}},r={};function s(e){var n=r[e];if(void 0!==n)return n.exports;var a=r[e]={exports:{}};return t[e](a,a.exports,s),a.exports}s.m=t,s.n=e=>{var t=e&&e.__esModule?()=>e.default:()=>e;return s.d(t,{a:t}),t},s.d=(e,t)=>{for(var r in t)s.o(t,r)&&!s.o(e,r)&&Object.defineProperty(e,r,{enumerable:!0,get:t[r]})},s.f={},s.e=e=>Promise.all(Object.keys(s.f).reduce(((t,r)=>(s.f[r](e,t),t)),[])),s.u=e=>"onechat.chunk."+e+".js",s.g=function(){if("object"==typeof globalThis)return globalThis;try{return this||new Function("return this")()}catch(e){if("object"==typeof window)return window}}(),s.o=(e,t)=>Object.prototype.hasOwnProperty.call(e,t),e={},s.l=(t,r,n,a)=>{if(e[t])e[t].push(r);else{var i,o;if(void 0!==n)for(var c=document.getElementsByTagName("script"),l=0;l<c.length;l++){var u=c[l];if(u.getAttribute("src")==t){i=u;break}}i||(o=!0,(i=document.createElement("script")).charset="utf-8",i.timeout=120,s.nc&&i.setAttribute("nonce",s.nc),i.src=t),e[t]=[r];var d=(r,s)=>{i.onerror=i.onload=null,clearTimeout(h);var n=e[t];if(delete e[t],i.parentNode&&i.parentNode.removeChild(i),n&&n.forEach((e=>e(s))),r)return r(s)},h=setTimeout(d.bind(null,void 0,{type:"timeout",target:i}),12e4);i.onerror=d.bind(null,i.onerror),i.onload=d.bind(null,i.onload),o&&document.head.appendChild(i)}},s.r=e=>{"undefined"!=typeof Symbol&&Symbol.toStringTag&&Object.defineProperty(e,Symbol.toStringTag,{value:"Module"}),Object.defineProperty(e,"__esModule",{value:!0})},(()=>{var e;s.g.importScripts&&(e=s.g.location+"");var t=s.g.document;if(!e&&t&&(t.currentScript&&"SCRIPT"===t.currentScript.tagName.toUpperCase()&&(e=t.currentScript.src),!e)){var r=t.getElementsByTagName("script");if(r.length)for(var n=r.length-1;n>-1&&(!e||!/^http(s?):/.test(e));)e=r[n--].src}if(!e)throw new Error("Automatic publicPath is not supported in this browser");e=e.replace(/#.*$/,"").replace(/\?.*$/,"").replace(/\/[^\/]+$/,"/"),s.p=e})(),(()=>{var e={35:0};s.f.j=(t,r)=>{var n=s.o(e,t)?e[t]:void 0;if(0!==n)if(n)r.push(n[2]);else{var a=new Promise(((r,s)=>n=e[t]=[r,s]));r.push(n[2]=a);var i=s.p+s.u(t),o=new Error;s.l(i,(r=>{if(s.o(e,t)&&(0!==(n=e[t])&&(e[t]=void 0),n)){var a=r&&("load"===r.type?"missing":r.type),i=r&&r.target&&r.target.src;o.message="Loading chunk "+t+" failed.\n("+a+": "+i+")",o.name="ChunkLoadError",o.type=a,o.request=i,n[1](o)}}),"chunk-"+t,t)}};var t=(t,r)=>{var n,a,[i,o,c]=r,l=0;if(i.some((t=>0!==e[t]))){for(n in o)s.o(o,n)&&(s.m[n]=o[n]);c&&c(s)}for(t&&t(r);l<i.length;l++)a=i[l],s.o(e,a)&&e[a]&&e[a][0](),e[a]=0},r=self.onechat_bundle_jsonpfunction=self.onechat_bundle_jsonpfunction||[];r.forEach(t.bind(null,0)),r.push=t.bind(null,r.push.bind(r))})(),s(6765),__kbnBundles__.define("plugin/onechat/public",s,1862)})();