"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerManagementSection = exports.registerApp = exports.registerAnalytics = void 0;
var _coreApplicationCommon = require("@kbn/core-application-common");
var _i18n = require("@kbn/i18n");
var _events = require("../common/events");
var _features = require("../common/features");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const registerApp = ({
  core,
  getServices
}) => {
  core.application.register({
    id: _features.ONECHAT_APP_ID,
    appRoute: _features.ONECHAT_PATH,
    category: _coreApplicationCommon.DEFAULT_APP_CATEGORIES.enterpriseSearch,
    title: _features.AGENT_BUILDER_SHORT_TITLE,
    euiIconType: 'logoElasticsearch',
    visibleIn: ['sideNav', 'globalSearch'],
    deepLinks: [{
      id: 'conversations',
      path: '/conversations',
      title: _i18n.i18n.translate('xpack.onechat.chat.conversationsTitle', {
        defaultMessage: 'Agent Chat'
      })
    }, {
      id: 'tools',
      path: '/tools',
      title: _i18n.i18n.translate('xpack.onechat.tools.title', {
        defaultMessage: 'Tools'
      })
    }, {
      id: 'agents',
      path: '/agents',
      title: _i18n.i18n.translate('xpack.onechat.agents.title', {
        defaultMessage: 'Agents'
      })
    }],
    async mount({
      element,
      history
    }) {
      const {
        mountApp
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('./application')));
      const [coreStart, startDependencies] = await core.getStartServices();
      coreStart.chrome.docTitle.change(_features.AGENT_BUILDER_FULL_TITLE);
      const services = getServices();
      return mountApp({
        core: coreStart,
        services,
        element,
        history,
        plugins: startDependencies
      });
    }
  });
};
exports.registerApp = registerApp;
const registerManagementSection = ({
  core,
  management
}) => {
  management.sections.section.ai.registerApp({
    id: 'agentBuilder',
    title: _features.AGENT_BUILDER_FULL_TITLE,
    order: 3,
    mount: async mountParams => {
      const {
        mountManagementSection
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('./management/mount_management_section')));
      return mountManagementSection({
        core,
        mountParams
      });
    }
  });
};
exports.registerManagementSection = registerManagementSection;
const registerAnalytics = ({
  analytics
}) => {
  analytics.registerEventType({
    eventType: _events.eventTypes.ONECHAT_CONVERSE_ERROR,
    schema: {
      error_type: {
        type: 'keyword',
        _meta: {
          description: 'The type/name of the error that occurred during conversation'
        }
      },
      error_message: {
        type: 'text',
        _meta: {
          description: 'The error message describing what went wrong'
        }
      },
      error_stack: {
        type: 'text',
        _meta: {
          description: 'The error stack trace if available',
          optional: true
        }
      },
      conversation_id: {
        type: 'keyword',
        _meta: {
          description: 'The ID of the conversation where the error occurred',
          optional: true
        }
      },
      agent_id: {
        type: 'keyword',
        _meta: {
          description: 'The ID of the agent involved in the conversation',
          optional: true
        }
      },
      connector_id: {
        type: 'keyword',
        _meta: {
          description: 'The ID of the connector used for the conversation',
          optional: true
        }
      }
    }
  });
};
exports.registerAnalytics = registerAnalytics;