"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.transformBuiltInToolToFormData = void 0;
var _onechatCommon = require("@kbn/onechat-common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Transforms a built-in tool definition into its UI form representation.
 * @param tool - The built-in tool definition to transform.
 * @returns The built-in tool form data.
 */
const transformBuiltInToolToFormData = tool => {
  return {
    toolId: tool.id,
    description: tool.description,
    labels: tool.tags,
    type: _onechatCommon.ToolType.builtin
  };
};
exports.transformBuiltInToolToFormData = transformBuiltInToolToFormData;