"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.labels = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const labels = exports.labels = {
  common: {
    optional: _i18n.i18n.translate('xpack.onechat.common.optional', {
      defaultMessage: 'Optional'
    })
  },
  conversations: {
    title: _i18n.i18n.translate('xpack.onechat.conversations.title', {
      defaultMessage: 'Agent Chat'
    }),
    manageAgents: _i18n.i18n.translate('xpack.onechat.agents.manageAgents', {
      defaultMessage: 'Manage agents'
    }),
    createAnAgent: _i18n.i18n.translate('xpack.onechat.agents.createAnAgent', {
      defaultMessage: 'Create an agent'
    }),
    selectAgentAriaLabel: _i18n.i18n.translate('xpack.onechat.agents.selectAgentAriaLabel', {
      defaultMessage: 'Select an agent'
    })
  },
  tools: {
    // Landing page
    title: _i18n.i18n.translate('xpack.onechat.tools.title', {
      defaultMessage: 'Tools'
    }),
    newToolButton: _i18n.i18n.translate('xpack.onechat.tools.newToolButton', {
      defaultMessage: 'New tool'
    }),
    newToolTitle: _i18n.i18n.translate('xpack.onechat.tools.newToolTitle', {
      defaultMessage: 'Create a new tool'
    }),
    readOnly: _i18n.i18n.translate('xpack.onechat.tools.readOnly', {
      defaultMessage: 'Read-only'
    }),
    newIndexSearchToolTitle: _i18n.i18n.translate('xpack.onechat.tools.newIndexSearchTool.title', {
      defaultMessage: 'New index search tool'
    }),
    editIndexSearchToolTitle: _i18n.i18n.translate('xpack.onechat.tools.editIndexSearchTool.title', {
      defaultMessage: 'Edit index search tool'
    }),
    editToolContextMenuButtonLabel: _i18n.i18n.translate('xpack.onechat.tools.editToolContextMenuButtonLabel', {
      defaultMessage: 'Edit tool context menu'
    }),
    saveButtonLabel: _i18n.i18n.translate('xpack.onechat.tools.saveButtonLabel', {
      defaultMessage: 'Save'
    }),
    testButtonLabel: _i18n.i18n.translate('xpack.onechat.tools.testButtonLabel', {
      defaultMessage: 'Test'
    }),
    saveAndTestButtonLabel: _i18n.i18n.translate('xpack.onechat.tools.saveAndTestButtonLabel', {
      defaultMessage: 'Save & test'
    }),
    cancelButtonLabel: _i18n.i18n.translate('xpack.onechat.tools.cancelButtonLabel', {
      defaultMessage: 'Cancel'
    }),
    saveButtonTooltip: _i18n.i18n.translate('xpack.onechat.tools.saveButtonTooltip', {
      defaultMessage: 'Resolve all form errors to save.'
    }),
    // Table columns and labels
    toolIdLabel: _i18n.i18n.translate('xpack.onechat.tools.idLabel', {
      defaultMessage: 'ID'
    }),
    tagsLabel: _i18n.i18n.translate('xpack.onechat.tools.tagsLabel', {
      defaultMessage: 'Labels'
    }),
    toolsLabel: _i18n.i18n.translate('xpack.onechat.tools.toolsLabel', {
      defaultMessage: 'Tools'
    }),
    // Tool types
    esqlLabel: _i18n.i18n.translate('xpack.onechat.tools.esqlLabel', {
      defaultMessage: 'ES|QL'
    }),
    builtinLabel: _i18n.i18n.translate('xpack.onechat.tools.builtinLabel', {
      defaultMessage: 'System'
    }),
    searchLabel: _i18n.i18n.translate('xpack.onechat.tools.searchLabel', {
      defaultMessage: 'Search'
    }),
    indexTypeLabel: _i18n.i18n.translate('xpack.onechat.tools.indexTypeLabel', {
      defaultMessage: 'Index'
    }),
    aliasTypeLabel: _i18n.i18n.translate('xpack.onechat.tools.aliasTypeLabel', {
      defaultMessage: 'Alias'
    }),
    dataStreamTypeLabel: _i18n.i18n.translate('xpack.onechat.tools.dataStreamTypeLabel', {
      defaultMessage: 'Data stream'
    }),
    // Actions
    editToolButtonLabel: _i18n.i18n.translate('xpack.onechat.tools.editToolButtonLabel', {
      defaultMessage: 'Edit'
    }),
    viewToolButtonLabel: _i18n.i18n.translate('xpack.onechat.tools.viewToolButtonLabel', {
      defaultMessage: 'View'
    }),
    deleteToolButtonLabel: _i18n.i18n.translate('xpack.onechat.tools.deleteToolButtonLabel', {
      defaultMessage: 'Delete'
    }),
    testToolButtonLabel: _i18n.i18n.translate('xpack.onechat.tools.testToolButtonLabel', {
      defaultMessage: 'Test'
    }),
    cloneToolButtonLabel: _i18n.i18n.translate('xpack.onechat.tools.cloneToolButtonLabel', {
      defaultMessage: 'Clone'
    }),
    toolContextMenuButtonLabel: _i18n.i18n.translate('xpack.onechat.tools.toolContextMenuButtonLabel', {
      defaultMessage: 'Tool context menu'
    }),
    // Table header and bulk actions
    deleteSelectedToolsButtonLabel: count => _i18n.i18n.translate('xpack.onechat.tools.deleteSelectedToolsButtonLabel', {
      defaultMessage: 'Delete {count, plural, one {# Tool} other {# Tools}}',
      values: {
        count
      }
    }),
    selectAllToolsButtonLabel: _i18n.i18n.translate('xpack.onechat.tools.selectAllToolsButtonLabel', {
      defaultMessage: 'Select all'
    }),
    clearSelectionButtonLabel: _i18n.i18n.translate('xpack.onechat.tools.clearSelectionButtonLabel', {
      defaultMessage: 'Clear selection'
    }),
    includeSystemToolsSwitchLabel: _i18n.i18n.translate('xpack.onechat.tools.includeSystemToolsSwitchLabel', {
      defaultMessage: 'Include system tools'
    }),
    // Search and filters
    searchToolsPlaceholder: _i18n.i18n.translate('xpack.onechat.tools.searchToolsPlaceholder', {
      defaultMessage: 'Search'
    }),
    typeFilter: _i18n.i18n.translate('xpack.onechat.tools.typeFilter', {
      defaultMessage: 'Type'
    }),
    tagsFilter: _i18n.i18n.translate('xpack.onechat.tools.tagsFilter', {
      defaultMessage: 'Labels'
    }),
    // Empty states and messages
    noEsqlToolsMatchMessage: _i18n.i18n.translate('xpack.onechat.tools.noEsqlToolsMatchMessage', {
      defaultMessage: 'No tools match your search.'
    }),
    noEsqlToolsMessage: _i18n.i18n.translate('xpack.onechat.tools.noEsqlToolsMessage', {
      defaultMessage: "It looks like you don't have any ES|QL tools defined yet."
    }),
    listToolsErrorMessage: _i18n.i18n.translate('xpack.onechat.tools.listToolsErrorMessage', {
      defaultMessage: 'Failed to fetch tools'
    }),
    // Success toasts
    deleteToolSuccessToast: toolId => _i18n.i18n.translate('xpack.onechat.tools.deleteToolSuccessToast', {
      defaultMessage: 'Tool "{toolId}" deleted',
      values: {
        toolId
      }
    }),
    bulkDeleteToolsSuccessToast: count => _i18n.i18n.translate('xpack.onechat.tools.bulkDeleteToolsSuccessToast', {
      defaultMessage: 'Deleted {count, plural, one {# tool} other {# tools}}',
      values: {
        count
      }
    }),
    createEsqlToolSuccessToast: toolId => _i18n.i18n.translate('xpack.onechat.tools.createEsqlToolSuccessToast', {
      defaultMessage: 'Tool "{toolId}" created',
      values: {
        toolId
      }
    }),
    editEsqlToolSuccessToast: toolId => _i18n.i18n.translate('xpack.onechat.tools.editEsqlToolSuccessToast', {
      defaultMessage: 'Tool "{toolId}" updated',
      values: {
        toolId
      }
    }),
    createIndexSearchToolSuccessToast: toolId => _i18n.i18n.translate('xpack.onechat.tools.createIndexSearchToolSuccessToast', {
      defaultMessage: 'Tool "{toolId}" created',
      values: {
        toolId
      }
    }),
    editIndexSearchToolSuccessToast: toolId => _i18n.i18n.translate('xpack.onechat.tools.editIndexSearchToolSuccessToast', {
      defaultMessage: 'Tool "{toolId}" updated',
      values: {
        toolId
      }
    }),
    // Error toasts
    deleteToolErrorToast: toolId => _i18n.i18n.translate('xpack.onechat.tools.deleteToolErrorToast', {
      defaultMessage: 'Unable to delete tool "{toolId}"',
      values: {
        toolId
      }
    }),
    bulkDeleteToolsErrorToast: count => _i18n.i18n.translate('xpack.onechat.tools.bulkDeleteToolsErrorToast', {
      defaultMessage: 'Unable to delete {count, plural, one {# tool} other {# tools}}',
      values: {
        count
      }
    }),
    createEsqlToolErrorToast: _i18n.i18n.translate('xpack.onechat.tools.createEsqlToolErrorToast', {
      defaultMessage: 'Unable to create tool'
    }),
    editEsqlToolErrorToast: toolId => _i18n.i18n.translate('xpack.onechat.tools.editEsqlToolErrorToast', {
      defaultMessage: 'Unable to update tool "{toolId}"',
      values: {
        toolId
      }
    }),
    searchToolsErrorToast: _i18n.i18n.translate('xpack.onechat.tools.searchToolsErrorToast', {
      defaultMessage: 'Error searching tools'
    }),
    loadToolErrorToast: toolId => _i18n.i18n.translate('xpack.onechat.tools.loadToolErrorToast', {
      defaultMessage: 'Unable to load "{toolId}"',
      values: {
        toolId
      }
    }),
    loadToolsErrorToast: _i18n.i18n.translate('xpack.onechat.tools.loadToolsErrorToast', {
      defaultMessage: 'Unable to load tools'
    }),
    // Delete modals
    deleteEsqlToolTitle: toolId => _i18n.i18n.translate('xpack.onechat.tools.deleteEsqlToolTitle', {
      defaultMessage: 'Delete {toolId}?',
      values: {
        toolId
      }
    }),
    deleteEsqlToolCancelButton: _i18n.i18n.translate('xpack.onechat.tools.deleteEsqlToolCancelButton', {
      defaultMessage: 'Cancel'
    }),
    deleteEsqlToolConfirmButton: _i18n.i18n.translate('xpack.onechat.tools.deleteEsqlToolConfirmButton', {
      defaultMessage: 'Delete tool'
    }),
    deleteEsqlToolConfirmationText: _i18n.i18n.translate('xpack.onechat.tools.deleteEsqlToolConfirmationText', {
      defaultMessage: 'This action will permanently remove the tool. This cannot be undone.'
    }),
    // Bulk delete modal
    bulkDeleteEsqlToolsTitle: count => _i18n.i18n.translate('xpack.onechat.tools.bulkDeleteEsqlToolsTitle', {
      defaultMessage: 'Delete {count, plural, one {# tool} other {# tools}}?',
      values: {
        count
      }
    }),
    bulkDeleteEsqlToolsConfirmationText: _i18n.i18n.translate('xpack.onechat.tools.bulkDeleteEsqlToolsConfirmationText', {
      defaultMessage: "You can't recover deleted data."
    }),
    testTool: {
      backToEditToolButton: _i18n.i18n.translate('xpack.onechat.tools.testTool.backToEditToolButton', {
        defaultMessage: 'Back to edit tool'
      })
    }
  },
  agents: {
    title: _i18n.i18n.translate('xpack.onechat.agents.list.title', {
      defaultMessage: 'Agents'
    }),
    newAgent: _i18n.i18n.translate('xpack.onechat.agents.new.title', {
      defaultMessage: 'New Agent'
    }),
    editAgent: _i18n.i18n.translate('xpack.onechat.agents.edit.title', {
      defaultMessage: 'Edit Agent'
    }),
    createAgent: _i18n.i18n.translate('xpack.onechat.agents.create.title', {
      defaultMessage: 'Create Agent'
    }),
    settings: {
      cancelButtonLabel: _i18n.i18n.translate('xpack.onechat.agents.form.settings.cancelButtonLabel', {
        defaultMessage: 'Cancel'
      })
    }
  },
  management: {
    agentBuilder: _i18n.i18n.translate('xpack.onechat.management.agentBuilder.title', {
      defaultMessage: 'Agent Builder'
    })
  }
};