"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NewConversationButton = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _use_navigation = require("../../hooks/use_navigation");
var _app_paths = require("../../utils/app_paths");
var _use_conversation_id = require("../../hooks/use_conversation_id");
var _use_is_sending_message = require("../../hooks/use_is_sending_message");
var _send_message_context = require("../../context/send_message/send_message_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/onechat/public/application/components/conversations/new_conversation_button.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const NewConversationButton = () => {
  const {
    createOnechatUrl
  } = (0, _use_navigation.useNavigation)();
  const conversationId = (0, _use_conversation_id.useConversationId)();
  const isNewConversation = !conversationId;
  const isSendingMessage = (0, _use_is_sending_message.useIsSendingMessage)();
  const {
    cleanConversation
  } = (0, _send_message_context.useSendMessage)();
  // Only disable when we are on /new and there is a message being sent
  const isDisabled = isNewConversation && isSendingMessage;
  const handleClick = () => {
    // For new conversations, there isn't anywhere to navigate to, so instead we clean the conversation state
    if (isNewConversation) {
      cleanConversation();
    }
  };
  const buttonProps = isDisabled ? {
    disabled: true
  } : {
    href: createOnechatUrl(_app_paths.appPaths.chat.new)
  };
  const labels = {
    ariaLabel: _i18n.i18n.translate('xpack.onechat.newConversationButton.ariaLabel', {
      defaultMessage: 'Create new conversation'
    }),
    display: _i18n.i18n.translate('xpack.onechat.newConversationButton.display', {
      defaultMessage: 'New'
    })
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButton, (0, _extends2.default)({
    iconType: "plus",
    iconSide: "left",
    "aria-label": labels.ariaLabel,
    onClick: handleClick,
    "data-test-subj": "agentBuilderNewConversationButton"
  }, buttonProps, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 5
    }
  }), labels.display);
};
exports.NewConversationButton = NewConversationButton;