"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StreamingText = void 0;
var _react = _interopRequireWildcard(require("react"));
var _chat_message_text = require("./chat_message_text");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/onechat/public/application/components/conversations/conversation_rounds/streaming_text.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const TOKEN_DELAY = 17;
const StreamingText = ({
  content,
  steps,
  tokenDelay = TOKEN_DELAY
}) => {
  const [displayedText, setDisplayedText] = (0, _react.useState)('');
  const tokenQueueRef = (0, _react.useRef)([]);
  const intervalRef = (0, _react.useRef)(null);
  const previousContentLengthRef = (0, _react.useRef)(0);
  (0, _react.useEffect)(() => {
    const previousContentLength = previousContentLengthRef.current;
    const newContent = content.slice(previousContentLength);
    if (newContent.length > 0) {
      // Split the new content into tokens, preserving spaces
      const tokens = newContent.split(/(\s+)/).filter(token => token.length > 0);
      tokenQueueRef.current.push(...tokens);
      previousContentLengthRef.current = content.length;
    }
    if (!intervalRef.current && tokenQueueRef.current.length > 0) {
      intervalRef.current = setInterval(() => {
        if (tokenQueueRef.current.length === 0) {
          clearInterval(intervalRef.current);
          intervalRef.current = null;
          return;
        }
        const nextToken = tokenQueueRef.current.shift();
        if (nextToken) {
          setDisplayedText(prev => prev + nextToken);
        }
      }, tokenDelay);
    }
    return () => {
      if (intervalRef.current) {
        clearInterval(intervalRef.current);
        intervalRef.current = null;
      }
    };
  }, [content, tokenDelay]);
  return /*#__PURE__*/_react.default.createElement(_chat_message_text.ChatMessageText, {
    content: displayedText,
    steps: steps,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 10
    }
  });
};
exports.StreamingText = StreamingText;