"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.progressMessages = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const progressMessages = exports.progressMessages = {
  selectingTarget: () => {
    return _i18n.i18n.translate('xpack.onechat.tools.search.progress.selectingTarget', {
      defaultMessage: 'Selecting the best target for this query'
    });
  },
  selectedTarget: target => {
    return _i18n.i18n.translate('xpack.onechat.tools.search.progress.selectedTarget', {
      defaultMessage: 'Selected "{target}" as the next search target',
      values: {
        target
      }
    });
  },
  resolvingSearchStrategy: () => {
    return _i18n.i18n.translate('xpack.onechat.tools.search.progress.searchStrategy', {
      defaultMessage: 'Thinking about the search strategy to use'
    });
  },
  performingRelevanceSearch: ({
    term
  }) => {
    return _i18n.i18n.translate('xpack.onechat.tools.search.progress.performingRelevanceSearch', {
      defaultMessage: 'Searching documents for "{term}"',
      values: {
        term
      }
    });
  },
  performingNlSearch: ({
    query
  }) => {
    return _i18n.i18n.translate('xpack.onechat.tools.search.progress.performingTextSearch', {
      defaultMessage: 'Generating an ES|QL query for "{query}"',
      values: {
        query
      }
    });
  }
};