"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DeleteAnnotations = DeleteAnnotations;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/observability/public/components/annotations/components/common/delete_annotations.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function DeleteAnnotations({
  selection,
  isLoading,
  permissions,
  setIsDeleteModalVisible
}) {
  if (selection.length === 0) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, " ");
  }
  const btn = /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "o11yRenderToolsLeftUsersButton",
    color: "danger",
    iconType: "trash",
    onClick: () => {
      setIsDeleteModalVisible(true);
    },
    isLoading: isLoading,
    isDisabled: selection.length === 0 || !(permissions !== null && permissions !== void 0 && permissions.write),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 29,
      columnNumber: 5
    }
  }, _i18n.i18n.translate('xpack.observability.renderToolsLeft.deleteButtonLabel', {
    defaultMessage: 'Delete {no} annotations',
    values: {
      no: selection.length
    }
  }));
  if (permissions !== null && permissions !== void 0 && permissions.write) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, btn);
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: _i18n.i18n.translate('xpack.observability.renderToolsLeft.deleteButtonDisabledTooltip', {
      defaultMessage: 'You do not have permission to delete annotations'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 5
    }
  }, btn);
}