"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CreateStackInAWSConsole = CreateStackInAWSConsole;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireDefault(require("react"));
var _pricing_features = require("../../../../common/pricing_features");
var _aws_firehose = require("../../../../common/aws_firehose");
var _download_template_callout = require("./download_template_callout");
var _utils = require("./utils");
var _use_pricing_feature = require("../shared/use_pricing_feature");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/observability_onboarding/public/application/quickstart_flows/firehose/create_stack_in_aws_console.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function CreateStackInAWSConsole({
  encodedApiKey,
  elasticsearchUrl,
  templateUrl,
  isPrimaryAction,
  metricsEnabled = true
}) {
  const metricsOnboardingEnabled = (0, _use_pricing_feature.usePricingFeature)(_pricing_features.ObservabilityOnboardingPricingFeature.METRICS_ONBOARDING);
  const awsConsoleURL = (0, _utils.buildCreateStackAWSConsoleURL)({
    templateUrl,
    stackName: _aws_firehose.FIREHOSE_CLOUDFORMATION_STACK_NAME,
    streamName: _aws_firehose.FIREHOSE_STREAM_NAME,
    elasticsearchUrl,
    encodedApiKey,
    metricsEnabled
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 9
    }
  }, metricsOnboardingEnabled && /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.observability_onboarding.firehosePanel.createFirehoseStreamInAWSConsoleDescription",
    defaultMessage: "Click the button below to create a CloudFormation stack from our template. The stack will include a Firehose delivery stream, backup S3 bucket, CloudWatch subscription filter, metrics stream, and necessary IAM roles. Keep this page open, and return once you've submitted the form in AWS Console",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 13
    }
  }), !metricsOnboardingEnabled && /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.observability_onboarding.logsEssential.firehosePanel.createFirehoseStreamInAWSConsoleDescription",
    defaultMessage: "Click the button below to create a CloudFormation stack from our template. The stack will include a Firehose delivery stream, backup S3 bucket, CloudWatch subscription filter and necessary IAM roles. Keep this page open, and return once you've submitted the form in AWS Console",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement("p", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_download_template_callout.DownloadTemplateCallout, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "observabilityOnboardingCreateStackInAWSConsoleButton",
    href: awsConsoleURL,
    target: "_blank",
    iconSide: "right",
    iconType: "popout",
    fill: isPrimaryAction,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 7
    }
  }, _i18n.i18n.translate('xpack.observability_onboarding.createStackInAWSConsole.createFirehoseStreamInAWSConsoleButtonLabel', {
    defaultMessage: 'Create Firehose Stream in AWS'
  })));
}