"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InfoTooltip = InfoTooltip;
var _react = _interopRequireDefault(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/monitoring/public/components/chart/info_tooltip.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const tooltipLabelStyle = theme => (0, _react2.css)`
  text-align: left;
  font-size: ${(0, _eui.euiFontSize)(theme, 'xs').fontSize};
  padding: ${theme.euiTheme.size.xs};
  word-wrap: break-word;
  white-space: normal;
  font-weight: ${theme.euiTheme.font.weight.bold};
`;
const tooltipValueStyle = theme => (0, _react2.css)`
  text-align: left;
  font-size: ${(0, _eui.euiFontSize)(theme, 'xs').fontSize};
  padding: ${theme.euiTheme.size.xs};
  word-wrap: break-word;
  white-space: normal;
`;
function InfoTooltip({
  series,
  bucketSize
}) {
  const tableRows = series.map((item, index) => {
    return /*#__PURE__*/_react.default.createElement("tr", {
      key: `chart-tooltip-${index}`,
      "data-debug-metric-agg": item.metric.metricAgg,
      "data-debug-metric-field": item.metric.field,
      "data-debug-metric-is-derivative": item.metric.isDerivative,
      "data-debug-metric-has-calculation": item.metric.hasCalculation,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 42,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement("td", {
      css: tooltipLabelStyle,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 49,
        columnNumber: 9
      }
    }, item.metric.label), /*#__PURE__*/_react.default.createElement("td", {
      css: tooltipValueStyle,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 50,
        columnNumber: 9
      }
    }, item.metric.description));
  });
  return /*#__PURE__*/_react.default.createElement("table", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("tbody", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("tr", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("td", {
    css: tooltipLabelStyle,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.monitoring.chart.infoTooltip.intervalLabel",
    defaultMessage: "Interval",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement("td", {
    css: tooltipValueStyle,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 11
    }
  }, bucketSize)), tableRows));
}