"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ElasticsearchCcrShardPage = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _lodash = require("lodash");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/kibana-react-plugin/public");
var _page_template = require("../page_template");
var _global_state_context = require("../../contexts/global_state_context");
var _ccr_shard = require("../../../components/elasticsearch/ccr_shard");
var _setup_mode = require("../../../components/renderers/setup_mode");
var _setup_mode_context = require("../../../components/setup_mode/setup_mode_context");
var _fetch_alerts = require("../../../lib/fetch_alerts");
var _constants = require("../../../../common/constants");
var _use_breadcrumbs = require("../../hooks/use_breadcrumbs");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/monitoring/public/application/pages/elasticsearch/ccr_shard_page.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ElasticsearchCcrShardPage = ({
  clusters
}) => {
  var _services$data2;
  const globalState = (0, _react.useContext)(_global_state_context.GlobalStateContext);
  const {
    services
  } = (0, _public.useKibana)();
  const [data, setData] = (0, _react.useState)({});
  const {
    index,
    shardId
  } = (0, _reactRouterDom.useParams)();
  const {
    generate: generateBreadcrumbs
  } = (0, _use_breadcrumbs.useBreadcrumbContainerContext)();
  const clusterUuid = globalState.cluster_uuid;
  const cluster = (0, _lodash.find)(clusters, {
    cluster_uuid: clusterUuid
  });
  (0, _react.useEffect)(() => {
    if (cluster) {
      generateBreadcrumbs(cluster.cluster_name, {
        inElasticsearch: true,
        name: 'ccr',
        instance: `Index: ${index} Shard: ${shardId}`
      });
    }
  }, [cluster, generateBreadcrumbs, index, shardId]);
  const ccs = globalState.ccs;
  const [alerts, setAlerts] = (0, _react.useState)({});
  const title = _i18n.i18n.translate('xpack.monitoring.elasticsearch.ccr.shard.title', {
    defaultMessage: 'Elasticsearch - Ccr - Shard'
  });
  const pageTitle = _i18n.i18n.translate('xpack.monitoring.elasticsearch.ccr.shard.pageTitle', {
    defaultMessage: 'Elasticsearch Ccr Shard - Index: {followerIndex} Shard: {shardId}',
    values: {
      followerIndex: (0, _lodash.get)(data, 'stat.follower.index', (0, _lodash.get)(data, 'stat.follower_index')),
      shardId: (0, _lodash.get)(data, 'stat.follower.shard.number', (0, _lodash.get)(data, 'stat.shard_id'))
    }
  });
  const instance = _i18n.i18n.translate('xpack.monitoring.elasticsearch.ccr.shard.instanceTitle', {
    defaultMessage: 'Index: {followerIndex} Shard: {shardId}',
    values: {
      followerIndex: (0, _lodash.get)(data, 'stat.follower_index'),
      shardId: (0, _lodash.get)(data, 'stat.shard_id')
    }
  });
  const getPageData = (0, _react.useCallback)(async () => {
    var _services$data, _services$http;
    const bounds = (_services$data = services.data) === null || _services$data === void 0 ? void 0 : _services$data.query.timefilter.timefilter.getBounds();
    const url = `../api/monitoring/v1/clusters/${clusterUuid}/elasticsearch/ccr/${index}/shard/${shardId}`;
    if ((_services$http = services.http) !== null && _services$http !== void 0 && _services$http.fetch && clusterUuid) {
      var _services$http2;
      const response = await ((_services$http2 = services.http) === null || _services$http2 === void 0 ? void 0 : _services$http2.fetch(url, {
        method: 'POST',
        body: JSON.stringify({
          ccs,
          timeRange: {
            min: bounds.min.toISOString(),
            max: bounds.max.toISOString()
          }
        })
      }));
      setData(response);
      const alertsResponse = await (0, _fetch_alerts.fetchAlerts)({
        fetch: services.http.fetch,
        alertTypeIds: [_constants.RULE_CCR_READ_EXCEPTIONS],
        clusterUuid,
        filters: [{
          shardId
        }],
        timeRange: {
          min: bounds.min.valueOf(),
          max: bounds.max.valueOf()
        }
      });
      setAlerts(alertsResponse);
    }
  }, [ccs, clusterUuid, (_services$data2 = services.data) === null || _services$data2 === void 0 ? void 0 : _services$data2.query.timefilter.timefilter, services.http, index, shardId]);
  return /*#__PURE__*/_react.default.createElement(_page_template.PageTemplate, {
    title: title,
    pageTitle: pageTitle,
    getPageData: getPageData,
    "data-test-subj": "elasticsearchCcrShardPage",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_setup_mode.SetupModeRenderer, {
    productName: _constants.ELASTICSEARCH_SYSTEM_ID,
    instance: instance,
    render: ({
      flyoutComponent,
      bottomBarComponent
    }) => /*#__PURE__*/_react.default.createElement(_setup_mode_context.SetupModeContext.Provider, {
      value: {
        setupModeSupported: true
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 119,
        columnNumber: 11
      }
    }, flyoutComponent, /*#__PURE__*/_react.default.createElement(_ccr_shard.CcrShard, (0, _extends2.default)({}, data, {
      alerts: alerts,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 121,
        columnNumber: 13
      }
    })), bottomBarComponent),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 7
    }
  }));
};
exports.ElasticsearchCcrShardPage = ElasticsearchCcrShardPage;