"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnomalySource = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _common = require("@kbn/maps-plugin/common");
var _public = require("@kbn/maps-plugin/public");
var _anomaly_source_field = require("./anomaly_source_field");
var _locator = require("../../common/constants/locator");
var _util = require("./util");
var _update_anomaly_source_editor = require("./update_anomaly_source_editor");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/maps/anomaly_source.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const RESULT_LIMIT = 1000;
class AnomalySource {
  static createDescriptor(descriptor) {
    if (typeof descriptor.jobId !== 'string') {
      throw new Error('Job id is required for anomaly layer creation');
    }
    return {
      type: _common.SOURCE_TYPES.ES_ML_ANOMALIES,
      jobId: descriptor.jobId,
      typicalActual: descriptor.typicalActual || _util.ML_ANOMALY_LAYERS.ACTUAL
    };
  }
  constructor(sourceDescriptor, adapters) {
    (0, _defineProperty2.default)(this, "_descriptor", void 0);
    this._descriptor = AnomalySource.createDescriptor(sourceDescriptor);
  }
  async getGeoJsonWithMeta(layerName, searchFilters, registerCancelCallback, isRequestStillActive) {
    const results = await (0, _util.getResultsForJobId)(AnomalySource.mlResultsService, this._descriptor.jobId, this._descriptor.typicalActual, searchFilters);
    return {
      data: results,
      meta: {
        // Set this to true if data is incomplete (e.g. capping number of results to first 1k)
        areResultsTrimmed: results.features.length === RESULT_LIMIT
      }
    };
  }
  canFormatFeatureProperties() {
    return false;
  }
  cloneDescriptor() {
    return {
      type: this._descriptor.type,
      jobId: this._descriptor.jobId,
      typicalActual: this._descriptor.typicalActual
    };
  }
  createField({
    fieldName
  }) {
    if (fieldName !== 'record_score') {
      throw new Error('Record score field name is required');
    }
    return new _anomaly_source_field.AnomalySourceField({
      source: this,
      field: fieldName
    });
  }
  async createFieldFormatter(field) {
    return null;
  }
  destroy() {}
  getApplyGlobalQuery() {
    return true;
  }
  getApplyForceRefresh() {
    return false;
  }
  getApplyGlobalTime() {
    return true;
  }
  async getAttributions() {
    return [];
  }
  async getBoundsForFilters(boundsFilters, registerCancelCallback) {
    return null;
  }
  async getDisplayName() {
    return _i18n.i18n.translate('xpack.ml.maps.anomalySource.displayLabel', {
      defaultMessage: '{typicalActual} for {jobId}',
      values: {
        typicalActual: this._descriptor.typicalActual,
        jobId: this._descriptor.jobId
      }
    });
  }
  getFieldByName(fieldName) {
    if (fieldName === 'record_score') {
      return new _anomaly_source_field.AnomalySourceField({
        source: this,
        field: fieldName
      });
    }
    return null;
  }
  getSourceStatus(sourceDataRequest) {
    const meta = sourceDataRequest ? sourceDataRequest.getMeta() : null;
    if (meta !== null && meta !== void 0 && meta.areResultsTrimmed) {
      return {
        tooltipContent: _i18n.i18n.translate('xpack.ml.maps.resultsTrimmedMsg', {
          defaultMessage: `Results limited to first {count} documents.`,
          values: {
            count: RESULT_LIMIT
          }
        }),
        areResultsTrimmed: true
      };
    }
    return {
      tooltipContent: null,
      areResultsTrimmed: false
    };
  }
  getType() {
    return this._descriptor.type;
  }
  isMvt() {
    return false;
  }
  supportsJoins() {
    return false;
  }
  async getFields() {
    return Object.keys(_anomaly_source_field.ANOMALY_SOURCE_FIELDS).map(field => new _anomaly_source_field.AnomalySourceField({
      source: this,
      field
    }));
  }
  getGeoGridPrecision(zoom) {
    return 0;
  }
  isBoundsAware() {
    return false;
  }
  async getImmutableProperties(dataFilters) {
    let explorerLink;
    try {
      var _AnomalySource$mlLoca;
      explorerLink = await ((_AnomalySource$mlLoca = AnomalySource.mlLocator) === null || _AnomalySource$mlLoca === void 0 ? void 0 : _AnomalySource$mlLoca.getUrl({
        page: _locator.ML_PAGES.ANOMALY_EXPLORER,
        pageState: {
          jobIds: [this._descriptor.jobId],
          timeRange: dataFilters.timeFilters
        }
      }));
    } catch (error) {
      // ignore error if unable to get link
    }
    return [{
      label: _i18n.i18n.translate('xpack.ml.maps.anomalySourcePropLabel', {
        defaultMessage: 'Job Id'
      }),
      value: this._descriptor.jobId,
      ...(explorerLink ? {
        link: explorerLink
      } : {})
    }];
  }
  async isTimeAware() {
    return true;
  }
  renderSourceSettingsEditor({
    onChange
  }) {
    return /*#__PURE__*/_react.default.createElement(_update_anomaly_source_editor.UpdateAnomalySourceEditor, {
      onChange: onChange,
      typicalActual: this._descriptor.typicalActual,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 234,
        columnNumber: 7
      }
    });
  }
  async supportsFitToBounds() {
    // Return true if you can compute bounds of data
    return true;
  }
  async getLicensedFeatures() {
    return [];
  }
  getMaxZoom() {
    return _common.MAX_ZOOM;
  }
  getMinZoom() {
    return _common.MIN_ZOOM;
  }
  getSourceTooltipContent(sourceDataRequest) {
    var _meta$areResultsTrimm;
    const meta = sourceDataRequest ? sourceDataRequest.getMeta() : null;
    return {
      tooltipContent: _i18n.i18n.translate('xpack.ml.maps.sourceTooltip', {
        defaultMessage: 'Shows anomalies'
      }),
      // set to true if data is incomplete (we limit to first 1000 results)
      areResultsTrimmed: (_meta$areResultsTrimm = meta === null || meta === void 0 ? void 0 : meta.areResultsTrimmed) !== null && _meta$areResultsTrimm !== void 0 ? _meta$areResultsTrimm : false
    };
  }
  async getSupportedShapeTypes() {
    return this._descriptor.typicalActual === _util.ML_ANOMALY_LAYERS.TYPICAL_TO_ACTUAL ? [_common.VECTOR_SHAPE_TYPE.LINE] : [_common.VECTOR_SHAPE_TYPE.POINT];
  }
  getSyncMeta() {
    return {
      jobId: this._descriptor.jobId,
      typicalActual: this._descriptor.typicalActual
    };
  }
  async getTooltipProperties(properties) {
    const tooltipProperties = [];
    for (const key in properties) {
      if (key === _public.GEOJSON_FEATURE_ID_PROPERTY_NAME) {
        continue;
      }
      if (Object.hasOwn(properties, key)) {
        tooltipProperties.push(new _anomaly_source_field.AnomalySourceTooltipProperty(key, properties[key]));
      }
    }
    return tooltipProperties;
  }
  isFieldAware() {
    return true;
  }

  // This is for type-ahead support in the UX for by-value styling
  async getValueSuggestions(field, query) {
    return [];
  }

  // -----------------
  // API ML probably can ignore
  getAttributionProvider() {
    return null;
  }
  getInspectorAdapters() {
    // IGNORE: This is only relevant if your source is backed by an index-pattern
    return undefined;
  }
  getJoinsDisabledReason() {
    // IGNORE: This is only relevant if your source can be joined to other data
    return null;
  }
  async getLeftJoinFields() {
    // IGNORE: This is only relevant if your source can be joined to other data
    return [];
  }
  getFeatureActions(args) {
    return [];
  }
  isFilterByMapBounds() {
    // Only implement if you can query this data with a bounding-box
    return false;
  }
  isGeoGridPrecisionAware() {
    // Ignore: only implement if your data is scale-dependent (probably not)
    return false;
  }
  isQueryAware() {
    return true;
  }
  isRefreshTimerAware() {
    // Allow force-refresh when user clicks "refresh" button in the global time-picker
    return true;
  }
  async getTimesliceMaskFieldName() {
    return null;
  }
  async supportsFeatureEditing() {
    return false;
  }
  hasTooltipProperties() {
    return true;
  }
  async addFeature() {
    // should not be called
  }
  async deleteFeature() {
    // should not be called
  }
  getUpdateDueToTimeslice() {
    // TODO
    return true;
  }
  async getDefaultFields() {
    return {};
  }
  getInspectorRequestIds() {
    return [];
  }
}
exports.AnomalySource = AnomalySource;
(0, _defineProperty2.default)(AnomalySource, "mlResultsService", void 0);
(0, _defineProperty2.default)(AnomalySource, "mlLocator", void 0);