"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CalendarsListTable = void 0;
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _reactRouterDom = require("react-router-dom");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _calendars = require("../../../../../../common/constants/calendars");
var _use_create_url = require("../../../../contexts/kibana/use_create_url");
var _locator = require("../../../../../../common/constants/locator");
var _management = require("../../../../management");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/settings/calendars/list/table/table.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const CalendarsListTable = ({
  calendarsList,
  onDeleteClick,
  setSelectedCalendarList,
  loading,
  canCreateCalendar,
  canDeleteCalendar,
  mlNodesAvailable,
  itemsSelected,
  isDst
}) => {
  const redirectToNewCalendarPage = (0, _use_create_url.useCreateAndNavigateToManagementMlLink)(isDst ? _locator.ML_PAGES.CALENDARS_DST_NEW : _locator.ML_PAGES.CALENDARS_NEW, _management.MANAGEMENT_SECTION_IDS.AD_SETTINGS);
  const sorting = {
    sort: {
      field: 'calendar_id',
      direction: 'asc'
    }
  };
  const pagination = {
    initialPageSize: 20,
    pageSizeOptions: [10, 20]
  };
  const columns = [{
    field: 'calendar_id',
    name: _i18n.i18n.translate('xpack.ml.calendarsList.table.idColumnName', {
      defaultMessage: 'ID'
    }),
    sortable: true,
    truncateText: true,
    scope: 'row',
    render: id => /*#__PURE__*/_react.default.createElement(_reactRouterDom.Link, {
      to: `/${isDst ? _locator.ML_PAGES.CALENDARS_DST_EDIT : _locator.ML_PAGES.CALENDARS_EDIT}/${id}`,
      "data-test-subj": "mlEditCalendarLink",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 59,
        columnNumber: 9
      }
    }, id),
    'data-test-subj': 'mlCalendarListColumnId'
  }, {
    field: 'job_ids_string',
    name: _i18n.i18n.translate('xpack.ml.calendarsList.table.jobsColumnName', {
      defaultMessage: 'Jobs'
    }),
    sortable: true,
    truncateText: true,
    render: jobList => {
      return jobList === _calendars.GLOBAL_CALENDAR ? /*#__PURE__*/_react.default.createElement("span", {
        style: {
          fontStyle: 'italic'
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 77,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.calendarsList.table.allJobsLabel",
        defaultMessage: "Applies to all jobs",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 78,
          columnNumber: 13
        }
      })) : jobList;
    },
    'data-test-subj': 'mlCalendarListColumnJobs'
  }, {
    field: 'events_length',
    name: _i18n.i18n.translate('xpack.ml.calendarsList.table.eventsColumnName', {
      defaultMessage: 'Events'
    }),
    sortable: true,
    render: eventsLength => _i18n.i18n.translate('xpack.ml.calendarsList.table.eventsCountLabel', {
      defaultMessage: '{eventsLength, plural, one {# event} other {# events}}',
      values: {
        eventsLength
      }
    }),
    'data-test-subj': 'mlCalendarListColumnEvents'
  }];
  const tableSelection = {
    onSelectionChange: selection => setSelectedCalendarList(selection)
  };
  const search = {
    toolsRight: [/*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      size: "s",
      "data-test-subj": "mlCalendarButtonCreate",
      key: "new_calendar_button",
      onClick: redirectToNewCalendarPage,
      isDisabled: canCreateCalendar === false || mlNodesAvailable === false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 110,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.calendarsList.table.newButtonLabel",
      defaultMessage: "New",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 117,
        columnNumber: 9
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      size: "s",
      color: "danger",
      iconType: "trash",
      onClick: onDeleteClick,
      isDisabled: canDeleteCalendar === false || mlNodesAvailable === false || itemsSelected === false,
      "data-test-subj": "mlCalendarButtonDelete",
      key: "delete_calendar_button",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 119,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.calendarsList.table.deleteButtonLabel",
      defaultMessage: "Delete",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 130,
        columnNumber: 9
      }
    }))],
    box: {
      incremental: true
    },
    filters: []
  };
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "mlCalendarTableContainer",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 143,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    items: calendarsList,
    itemId: "calendar_id",
    columns: columns,
    search: search,
    pagination: pagination,
    sorting: sorting,
    loading: loading,
    selection: tableSelection,
    "data-test-subj": loading ? 'mlCalendarTable loading' : 'mlCalendarTable loaded',
    rowProps: item => ({
      'data-test-subj': `mlCalendarListRow row-${item.calendar_id}`
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 144,
      columnNumber: 7
    }
  }));
};
exports.CalendarsListTable = CalendarsListTable;
CalendarsListTable.propTypes = {
  calendarsList: _propTypes.default.array.isRequired,
  onDeleteClick: _propTypes.default.func.isRequired,
  loading: _propTypes.default.bool.isRequired,
  canCreateCalendar: _propTypes.default.bool.isRequired,
  canDeleteCalendar: _propTypes.default.bool.isRequired,
  mlNodesAvailable: _propTypes.default.bool.isRequired,
  setSelectedCalendarList: _propTypes.default.func.isRequired,
  itemsSelected: _propTypes.default.bool.isRequired
};