"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RawOutput = void 0;
var _react = _interopRequireDefault(require("react"));
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _ml_job_editor = require("../../../jobs/jobs_list/components/ml_job_editor");
var _inference_base = require("./inference_base");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/model_management/test_models/models/raw_output.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const RawOutput = ({
  inferrer
}) => {
  var _inferenceError$body;
  const inferenceError = (0, _useObservable.default)(inferrer.getInferenceError$(), inferrer.getInferenceError());
  const runningState = (0, _useObservable.default)(inferrer.getRunningState$(), inferrer.getRunningState());
  const inferenceResult = (0, _useObservable.default)(inferrer.getInferenceResult$(), inferrer.getInferenceResult());
  if (runningState === _inference_base.RUNNING_STATE.FINISHED_WITH_ERRORS && !inferenceError || runningState === _inference_base.RUNNING_STATE.FINISHED && !inferenceResult) {
    return null;
  }
  const resultResponse = [];
  if (inferenceResult) {
    for (const {
      rawResponse
    } of inferenceResult) {
      resultResponse.push(rawResponse);
    }
  }
  const rawResponse = runningState === _inference_base.RUNNING_STATE.FINISHED_WITH_ERRORS ? JSON.stringify((_inferenceError$body = inferenceError === null || inferenceError === void 0 ? void 0 : inferenceError.body) !== null && _inferenceError$body !== void 0 ? _inferenceError$body : inferenceError, null, 2) : JSON.stringify(inferrer.getInputType() === _inference_base.INPUT_TYPE.TEXT ? resultResponse[0] : resultResponse, null, 2);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_ml_job_editor.MLJobEditor, {
    "data-test-subj": 'mlTestModelRawOutput',
    value: rawResponse !== null && rawResponse !== void 0 ? rawResponse : '',
    readOnly: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 7
    }
  }));
};
exports.RawOutput = RawOutput;