"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SAVE_STATE = exports.Page = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _lodash = require("lodash");
var _moment = _interopRequireDefault(require("moment"));
var _mlIsPopulatedObject = require("@kbn/ml-is-populated-object");
var _mlQueryUtils = require("@kbn/ml-query-utils");
var _mlDateUtils = require("@kbn/ml-date-utils");
var _ml = require("../../../contexts/ml");
var _kibana = require("../../../contexts/kibana");
var _create_result_callout = require("./components/create_result_callout");
var _kibana_objects = require("./components/kibana_objects");
var _module_jobs = require("./components/module_jobs");
var _job_settings_form = require("./components/job_settings_form");
var _locator = require("../../../../../common/constants/locator");
var _jobs_awaiting_node_warning = require("../../../components/jobs_awaiting_node_warning");
var _page_header = require("../../../components/page_header");
var _page_title = require("../../../components/page_title");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/jobs/new_job/recognize/page.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
let SAVE_STATE = exports.SAVE_STATE = /*#__PURE__*/function (SAVE_STATE) {
  SAVE_STATE[SAVE_STATE["NOT_SAVED"] = 0] = "NOT_SAVED";
  SAVE_STATE[SAVE_STATE["SAVING"] = 1] = "SAVING";
  SAVE_STATE[SAVE_STATE["SAVED"] = 2] = "SAVED";
  SAVE_STATE[SAVE_STATE["FAILED"] = 3] = "FAILED";
  SAVE_STATE[SAVE_STATE["PARTIAL_FAILURE"] = 4] = "PARTIAL_FAILURE";
  return SAVE_STATE;
}({});
const Page = ({
  moduleId,
  existingGroupIds
}) => {
  var _selectedSavedSearch$;
  const {
    services: {
      notifications,
      mlServices: {
        mlApi: {
          getTimeFieldRange,
          setupDataRecognizerConfig,
          getDataRecognizerModule
        }
      }
    }
  } = (0, _kibana.useMlKibana)();
  const locator = (0, _kibana.useMlLocator)();

  // #region State
  const [jobPrefix, setJobPrefix] = (0, _react.useState)('');
  const [jobs, setJobs] = (0, _react.useState)([]);
  const [jobOverrides, setJobOverrides] = (0, _react.useState)({});
  const [kibanaObjects, setKibanaObjects] = (0, _react.useState)({});
  const [saveState, setSaveState] = (0, _react.useState)(SAVE_STATE.NOT_SAVED);
  const [resultsUrl, setResultsUrl] = (0, _react.useState)('');
  const [existingGroups, setExistingGroups] = (0, _react.useState)(existingGroupIds);
  const [jobsAwaitingNodeCount, setJobsAwaitingNodeCount] = (0, _react.useState)(0);
  // #endregion

  const {
    selectedSavedSearch,
    selectedDataView: dataView,
    combinedQuery
  } = (0, _ml.useDataSource)();
  const pageTitle = selectedSavedSearch ? _i18n.i18n.translate('xpack.ml.newJob.recognize.savedSearchPageTitle', {
    defaultMessage: 'Discover session {savedSearchTitle}',
    values: {
      savedSearchTitle: (_selectedSavedSearch$ = selectedSavedSearch.title) !== null && _selectedSavedSearch$ !== void 0 ? _selectedSavedSearch$ : ''
    }
  }) : _i18n.i18n.translate('xpack.ml.newJob.recognize.dataViewPageTitle', {
    defaultMessage: 'data view {dataViewName}',
    values: {
      dataViewName: dataView.getName()
    }
  });
  const displayQueryWarning = selectedSavedSearch !== null;
  const tempQuery = selectedSavedSearch === null ? undefined : combinedQuery;

  /**
   * Loads recognizer module configuration.
   */
  const loadModule = (0, _react.useCallback)(async () => {
    try {
      const response = await getDataRecognizerModule({
        moduleId
      });
      setJobs(response.jobs);
      setKibanaObjects(response.kibana);
      setSaveState(SAVE_STATE.NOT_SAVED);

      // mix existing groups from the server with the groups used across all jobs in the module.
      const moduleGroups = [...response.jobs.map(j => j.config.groups || [])].flat();
      const newGroups = [...new Set([...existingGroups, ...moduleGroups])].sort();
      if (!(0, _lodash.isEqual)(newGroups, existingGroups)) {
        setExistingGroups(newGroups);
      }
    } catch (e) {
      // eslint-disable-next-line no-console
      console.error(e);
    }
  }, [existingGroups, getDataRecognizerModule, moduleId]);
  const getTimeRange = (0, _react.useCallback)(async (useFullIndexData, timeRange) => {
    if (useFullIndexData) {
      const runtimeMappings = dataView.getComputedFields().runtimeFields;
      const {
        start,
        end
      } = await getTimeFieldRange({
        index: dataView.getIndexPattern(),
        timeFieldName: dataView.timeFieldName,
        // By default we want to use full non-frozen time range
        query: (0, _mlQueryUtils.addExcludeFrozenToQuery)(combinedQuery),
        ...((0, _mlIsPopulatedObject.isPopulatedObject)(runtimeMappings) ? {
          runtimeMappings
        } : {})
      });
      return {
        start,
        end
      };
    } else {
      return Promise.resolve(timeRange);
    }
  }, [combinedQuery, dataView, getTimeFieldRange]);
  (0, _react.useEffect)(() => {
    loadModule();
  }, [loadModule]);

  /**
   * Sets up recognizer module configuration.
   */
  const save = (0, _react.useCallback)(async formValues => {
    setSaveState(SAVE_STATE.SAVING);
    const {
      jobPrefix: resultJobPrefix,
      startDatafeedAfterSave,
      useDedicatedIndex,
      useFullIndexData,
      timeRange
    } = formValues;
    const resultTimeRange = await getTimeRange(useFullIndexData, timeRange);
    try {
      let jobOverridesPayload = Object.values(jobOverrides);
      jobOverridesPayload = jobOverridesPayload.length > 0 ? jobOverridesPayload : null;
      const response = await setupDataRecognizerConfig({
        moduleId,
        prefix: resultJobPrefix,
        query: tempQuery,
        indexPatternName: dataView.getIndexPattern(),
        useDedicatedIndex,
        startDatafeed: startDatafeedAfterSave,
        ...(jobOverridesPayload !== null ? {
          jobOverrides: jobOverridesPayload
        } : {}),
        ...resultTimeRange
      });
      const {
        datafeeds: datafeedsResponse,
        jobs: jobsResponse,
        kibana: kibanaResponse
      } = response;
      setJobs(jobs.map(job => {
        return {
          ...job,
          datafeedResult: datafeedsResponse.find(({
            id
          }) => id.endsWith(job.id)),
          setupResult: jobsResponse.find(({
            id
          }) => id === resultJobPrefix + job.id)
        };
      }));
      setKibanaObjects((0, _lodash.merge)(kibanaObjects, kibanaResponse));
      if (locator) {
        const url = await locator.getUrl({
          page: _locator.ML_PAGES.ANOMALY_EXPLORER,
          pageState: {
            jobIds: jobsResponse.filter(({
              success
            }) => success).map(({
              id
            }) => id),
            timeRange: {
              from: (0, _moment.default)(resultTimeRange.start).format(_mlDateUtils.TIME_FORMAT),
              to: (0, _moment.default)(resultTimeRange.end).format(_mlDateUtils.TIME_FORMAT),
              mode: 'absolute'
            }
          }
        });
        setResultsUrl(url);
      }
      const failedJobsCount = jobsResponse.reduce((count, {
        success
      }) => success ? count : count + 1, 0);
      const lazyJobsCount = datafeedsResponse.reduce((count, {
        awaitingMlNodeAllocation
      }) => awaitingMlNodeAllocation === true ? count + 1 : count, 0);
      setJobsAwaitingNodeCount(lazyJobsCount);
      setSaveState(failedJobsCount === 0 ? SAVE_STATE.SAVED : failedJobsCount === jobs.length ? SAVE_STATE.FAILED : SAVE_STATE.PARTIAL_FAILURE);
    } catch (e) {
      setSaveState(SAVE_STATE.FAILED);
      const {
        toasts
      } = notifications;
      toasts.addError(e, {
        title: _i18n.i18n.translate('xpack.ml.newJob.recognize.moduleSetupFailedWarningTitle', {
          defaultMessage: 'Error setting up module {moduleId}',
          values: {
            moduleId
          }
        }),
        toastMessage: _i18n.i18n.translate('xpack.ml.newJob.recognize.moduleSetupFailedWarningDescription', {
          defaultMessage: 'An error occurred trying to create the {count, plural, one {job} other {jobs}} in the module.',
          values: {
            count: jobs.length
          }
        })
      });
    }
  }, [dataView, getTimeRange, jobOverrides, jobs, kibanaObjects, locator, moduleId, notifications, setupDataRecognizerConfig, tempQuery]);
  const onJobOverridesChange = job => {
    setJobOverrides({
      ...jobOverrides,
      [job.job_id]: job
    });
    if (job.groups !== undefined) {
      // add newly added jobs to the list of existing groups
      // for use when editing other jobs in the module
      const groups = [...new Set([...existingGroups, ...job.groups])];
      setExistingGroups(groups);
    }
  };
  const isFormVisible = [SAVE_STATE.NOT_SAVED, SAVE_STATE.SAVING].includes(saveState);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_page_header.MlPageHeader, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 291,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_page_title.PageTitle, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.newJob.recognize.newJobFromTitle",
      defaultMessage: "New job from {pageTitle}",
      values: {
        pageTitle
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 294,
        columnNumber: 13
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 292,
      columnNumber: 9
    }
  })), displayQueryWarning && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.newJob.recognize.searchWillBeOverwrittenLabel",
      defaultMessage: "Search will be overwritten",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 307,
        columnNumber: 15
      }
    }),
    color: "warning",
    iconType: "warning",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 305,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 315,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.newJob.recognize.usingSavedSearchDescription",
    defaultMessage: "Using a saved Discover session will mean the query used in the datafeeds will be different from the default ones we supply in the {moduleId} module.",
    values: {
      moduleId
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 316,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 323,
      columnNumber: 11
    }
  })), jobsAwaitingNodeCount > 0 && /*#__PURE__*/_react.default.createElement(_jobs_awaiting_node_warning.JobsAwaitingNodeWarning, {
    jobCount: jobsAwaitingNodeCount,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 327,
      columnNumber: 37
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    wrap: true,
    gutterSize: "m",
    "data-test-subj": "mlPageJobWizard recognizer",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 329,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 330,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    grow: false,
    hasShadow: false,
    hasBorder: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 331,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 332,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("h4", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 333,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.newJob.recognize.jobSettingsTitle",
    defaultMessage: "Job settings",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 334,
      columnNumber: 17
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 341,
      columnNumber: 13
    }
  }), isFormVisible && /*#__PURE__*/_react.default.createElement(_job_settings_form.JobSettingsForm, {
    onSubmit: save,
    onJobPrefixChange: setJobPrefix,
    saveState: saveState,
    jobs: jobs,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 344,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_create_result_callout.CreateResultCallout, {
    saveState: saveState,
    resultsUrl: resultsUrl,
    onReset: loadModule,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 351,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 2,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 358,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    grow: false,
    hasShadow: false,
    hasBorder: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 359,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_module_jobs.ModuleJobs, {
    jobs: jobs,
    jobPrefix: jobPrefix,
    saveState: saveState,
    existingGroupIds: existingGroups,
    jobOverrides: jobOverrides,
    onJobOverridesChange: onJobOverridesChange,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 360,
      columnNumber: 13
    }
  })), Object.keys(kibanaObjects).length > 0 && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 371,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    grow: false,
    hasShadow: false,
    hasBorder: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 372,
      columnNumber: 15
    }
  }, Object.keys(kibanaObjects).map((objectType, i) => /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    key: objectType,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 374,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_kibana_objects.KibanaObjectList, {
    objectType: objectType,
    kibanaObjects: kibanaObjects[objectType],
    isSaving: saveState === SAVE_STATE.SAVING,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 375,
      columnNumber: 21
    }
  }), i < Object.keys(kibanaObjects).length - 1 && /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 380,
      columnNumber: 67
    }
  }))))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 388,
      columnNumber: 7
    }
  }));
};
exports.Page = Page;