"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSeverityOptions = void 0;
var _eui = require("@elastic/eui");
var _react = require("react");
var _mlAnomalyUtils = require("@kbn/ml-anomaly-utils");
var _i18n = require("@kbn/i18n");
var _select_severity = require("../../components/controls/select_severity");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const warningLabel = _i18n.i18n.translate('xpack.ml.controls.selectSeverity.warningLabel', {
  defaultMessage: 'warning'
});
const minorLabel = _i18n.i18n.translate('xpack.ml.controls.selectSeverity.minorLabel', {
  defaultMessage: 'minor'
});
const majorLabel = _i18n.i18n.translate('xpack.ml.controls.selectSeverity.majorLabel', {
  defaultMessage: 'major'
});
const criticalLabel = _i18n.i18n.translate('xpack.ml.controls.selectSeverity.criticalLabel', {
  defaultMessage: 'critical'
});
const lowLabel = _i18n.i18n.translate('xpack.ml.controls.selectSeverity.lowLabel', {
  defaultMessage: 'low'
});
/**
 * React hook that returns severity options with their display values and colors
 */
const useSeverityOptions = () => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return (0, _react.useMemo)(() => [{
    val: _mlAnomalyUtils.ML_ANOMALY_THRESHOLD.LOW,
    display: lowLabel,
    rangeDisplay: (0, _select_severity.getSeverityRangeDisplay)(_mlAnomalyUtils.ML_ANOMALY_THRESHOLD.LOW),
    color: (0, _mlAnomalyUtils.getThemeResolvedSeverityColor)(_mlAnomalyUtils.ML_ANOMALY_THRESHOLD.LOW, euiTheme),
    threshold: {
      min: _mlAnomalyUtils.ML_ANOMALY_THRESHOLD.LOW,
      max: _mlAnomalyUtils.ML_ANOMALY_THRESHOLD.WARNING
    }
  }, {
    val: _mlAnomalyUtils.ML_ANOMALY_THRESHOLD.WARNING,
    display: warningLabel,
    rangeDisplay: (0, _select_severity.getSeverityRangeDisplay)(_mlAnomalyUtils.ML_ANOMALY_THRESHOLD.WARNING),
    color: (0, _mlAnomalyUtils.getThemeResolvedSeverityColor)(_mlAnomalyUtils.ML_ANOMALY_THRESHOLD.WARNING, euiTheme),
    threshold: {
      min: _mlAnomalyUtils.ML_ANOMALY_THRESHOLD.WARNING,
      max: _mlAnomalyUtils.ML_ANOMALY_THRESHOLD.MINOR
    }
  }, {
    val: _mlAnomalyUtils.ML_ANOMALY_THRESHOLD.MINOR,
    display: minorLabel,
    rangeDisplay: (0, _select_severity.getSeverityRangeDisplay)(_mlAnomalyUtils.ML_ANOMALY_THRESHOLD.MINOR),
    color: (0, _mlAnomalyUtils.getThemeResolvedSeverityColor)(_mlAnomalyUtils.ML_ANOMALY_THRESHOLD.MINOR, euiTheme),
    threshold: {
      min: _mlAnomalyUtils.ML_ANOMALY_THRESHOLD.MINOR,
      max: _mlAnomalyUtils.ML_ANOMALY_THRESHOLD.MAJOR
    }
  }, {
    val: _mlAnomalyUtils.ML_ANOMALY_THRESHOLD.MAJOR,
    display: majorLabel,
    rangeDisplay: (0, _select_severity.getSeverityRangeDisplay)(_mlAnomalyUtils.ML_ANOMALY_THRESHOLD.MAJOR),
    color: (0, _mlAnomalyUtils.getThemeResolvedSeverityColor)(_mlAnomalyUtils.ML_ANOMALY_THRESHOLD.MAJOR, euiTheme),
    threshold: {
      min: _mlAnomalyUtils.ML_ANOMALY_THRESHOLD.MAJOR,
      max: _mlAnomalyUtils.ML_ANOMALY_THRESHOLD.CRITICAL
    }
  }, {
    val: _mlAnomalyUtils.ML_ANOMALY_THRESHOLD.CRITICAL,
    display: criticalLabel,
    rangeDisplay: (0, _select_severity.getSeverityRangeDisplay)(_mlAnomalyUtils.ML_ANOMALY_THRESHOLD.CRITICAL),
    color: (0, _mlAnomalyUtils.getThemeResolvedSeverityColor)(_mlAnomalyUtils.ML_ANOMALY_THRESHOLD.CRITICAL, euiTheme),
    threshold: {
      min: _mlAnomalyUtils.ML_ANOMALY_THRESHOLD.CRITICAL
    }
  }], [euiTheme]);
};
exports.useSeverityOptions = useSeverityOptions;