"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnnotationFlyoutUI = exports.AnnotationFlyout = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/kibana-react-plugin/public");
var _mlAnomalyUtils = require("@kbn/ml-anomaly-utils");
var _annotations = require("../../../../../common/constants/annotations");
var _annotations_service = require("../../../services/annotations_service");
var _annotation_description_list = require("../annotation_description_list");
var _delete_annotation_modal = require("../delete_annotation_modal");
var _annotations2 = require("../../../../../common/types/annotations");
var _ml_annotation_updates_context = require("../../../contexts/ml/ml_annotation_updates_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/components/annotations/annotation_flyout/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
class AnnotationFlyoutUI extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "deletionInProgress", false);
    (0, _defineProperty2.default)(this, "state", {
      isDeleteModalVisible: false,
      applyAnnotationToSeries: true,
      annotationState: null
    });
    (0, _defineProperty2.default)(this, "annotationSub", null);
    (0, _defineProperty2.default)(this, "annotationTextChangeHandler", e => {
      if (this.state.annotationState === null) {
        return;
      }
      const {
        annotationUpdatesService
      } = this.props;
      annotationUpdatesService.setValue({
        ...this.state.annotationState,
        annotation: e.target.value
      });
    });
    (0, _defineProperty2.default)(this, "cancelEditingHandler", () => {
      const {
        annotationUpdatesService
      } = this.props;
      annotationUpdatesService.setValue(null);
    });
    (0, _defineProperty2.default)(this, "deleteConfirmHandler", () => {
      this.setState({
        isDeleteModalVisible: true
      });
    });
    (0, _defineProperty2.default)(this, "deleteHandler", async () => {
      if (this.deletionInProgress) return;
      const {
        annotationState
      } = this.state;
      if (annotationState === null || annotationState._id === undefined) {
        return;
      }
      this.deletionInProgress = true;
      const mlApi = this.context.services.mlServices.mlApi;
      const toastNotifications = this.context.services.notifications.toasts;
      try {
        await mlApi.annotations.deleteAnnotation(annotationState._id);
        toastNotifications.addSuccess(_i18n.i18n.translate('xpack.ml.timeSeriesExplorer.timeSeriesChart.deletedAnnotationNotificationMessage', {
          defaultMessage: 'Deleted annotation for job with ID {jobId}.',
          values: {
            jobId: annotationState.job_id
          }
        }));
      } catch (err) {
        toastNotifications.addDanger(_i18n.i18n.translate('xpack.ml.timeSeriesExplorer.timeSeriesChart.errorWithDeletingAnnotationNotificationErrorMessage', {
          defaultMessage: 'An error occurred deleting the annotation for job with ID {jobId}: {error}',
          values: {
            jobId: annotationState.job_id,
            error: JSON.stringify(err)
          }
        }));
      }
      this.closeDeleteModal();
      this.deletionInProgress = false;
      const {
        annotationUpdatesService
      } = this.props;
      annotationUpdatesService.setValue(null);
      (0, _annotations_service.annotationsRefreshed)();
    });
    (0, _defineProperty2.default)(this, "closeDeleteModal", () => {
      this.setState({
        isDeleteModalVisible: false
      });
    });
    (0, _defineProperty2.default)(this, "validateAnnotationText", () => {
      // Validates the entered text, returning an array of error messages
      // for display in the form. An empty array is returned if the text is valid.
      const {
        annotationState
      } = this.state;
      const errors = [];
      if (annotationState === null) {
        return errors;
      }
      if (annotationState.annotation.trim().length === 0) {
        errors.push(_i18n.i18n.translate('xpack.ml.timeSeriesExplorer.annotationFlyout.noAnnotationTextError', {
          defaultMessage: 'Enter annotation text'
        }));
      }
      const textLength = annotationState.annotation.length;
      if (textLength > _annotations.ANNOTATION_MAX_LENGTH_CHARS) {
        const charsOver = textLength - _annotations.ANNOTATION_MAX_LENGTH_CHARS;
        errors.push(_i18n.i18n.translate('xpack.ml.timeSeriesExplorer.annotationFlyout.maxLengthError', {
          defaultMessage: '{charsOver, number} {charsOver, plural, one {character} other {characters}} above maximum length of {maxChars}',
          values: {
            maxChars: _annotations.ANNOTATION_MAX_LENGTH_CHARS,
            charsOver
          }
        }));
      }
      return errors;
    });
    (0, _defineProperty2.default)(this, "saveOrUpdateAnnotation", () => {
      var _chartDetails$entityD, _annotation$event;
      const {
        annotationState: originalAnnotation
      } = this.state;
      const {
        chartDetails,
        detectorIndex,
        annotationUpdatesService
      } = this.props;
      if (originalAnnotation === null) {
        return;
      }
      const annotation = (0, _lodash.cloneDeep)(originalAnnotation);
      if (this.state.applyAnnotationToSeries && chartDetails !== null && chartDetails !== void 0 && (_chartDetails$entityD = chartDetails.entityData) !== null && _chartDetails$entityD !== void 0 && _chartDetails$entityD.entities) {
        chartDetails.entityData.entities.forEach(entity => {
          const {
            fieldName,
            fieldValue
          } = entity;
          const fieldType = entity.fieldType;
          annotation[(0, _annotations2.getAnnotationFieldName)(fieldType)] = fieldName;
          annotation[(0, _annotations2.getAnnotationFieldValue)(fieldType)] = fieldValue;
        });
        annotation.detector_index = detectorIndex;
      }
      // if unchecked, remove all the partitions before indexing
      if (!this.state.applyAnnotationToSeries) {
        delete annotation.detector_index;
        _mlAnomalyUtils.ML_PARTITION_FIELDS.forEach(fieldType => {
          delete annotation[(0, _annotations2.getAnnotationFieldName)(fieldType)];
          delete annotation[(0, _annotations2.getAnnotationFieldValue)(fieldType)];
        });
      }
      // Mark the annotation created by `user` if and only if annotation is being created, not updated
      annotation.event = (_annotation$event = annotation.event) !== null && _annotation$event !== void 0 ? _annotation$event : _annotations.ANNOTATION_EVENT_USER;
      annotationUpdatesService.setValue(null);
      const mlApi = this.context.services.mlServices.mlApi;
      const toastNotifications = this.context.services.notifications.toasts;
      mlApi.annotations.indexAnnotation(annotation).then(() => {
        (0, _annotations_service.annotationsRefreshed)();
        if (typeof annotation._id === 'undefined') {
          toastNotifications.addSuccess(_i18n.i18n.translate('xpack.ml.timeSeriesExplorer.timeSeriesChart.addedAnnotationNotificationMessage', {
            defaultMessage: 'Added an annotation for job with ID {jobId}.',
            values: {
              jobId: annotation.job_id
            }
          }));
        } else {
          toastNotifications.addSuccess(_i18n.i18n.translate('xpack.ml.timeSeriesExplorer.timeSeriesChart.updatedAnnotationNotificationMessage', {
            defaultMessage: 'Updated annotation for job with ID {jobId}.',
            values: {
              jobId: annotation.job_id
            }
          }));
        }
      }).catch(resp => {
        if (typeof annotation._id === 'undefined') {
          toastNotifications.addDanger(_i18n.i18n.translate('xpack.ml.timeSeriesExplorer.timeSeriesChart.errorWithCreatingAnnotationNotificationErrorMessage', {
            defaultMessage: 'An error occurred creating the annotation for job with ID {jobId}: {error}',
            values: {
              jobId: annotation.job_id,
              error: JSON.stringify(resp)
            }
          }));
        } else {
          toastNotifications.addDanger(_i18n.i18n.translate('xpack.ml.timeSeriesExplorer.timeSeriesChart.errorWithUpdatingAnnotationNotificationErrorMessage', {
            defaultMessage: 'An error occurred updating the annotation for job with ID {jobId}: {error}',
            values: {
              jobId: annotation.job_id,
              error: JSON.stringify(resp)
            }
          }));
        }
      });
    });
  }
  componentDidMount() {
    const {
      annotationUpdatesService
    } = this.props;
    this.annotationSub = annotationUpdatesService.update$().subscribe(v => {
      this.setState({
        annotationState: v
      });
    });
  }
  componentWillUnmount() {
    this.annotationSub.unsubscribe();
  }
  render() {
    const {
      detectors,
      detectorIndex
    } = this.props;
    const {
      annotationState,
      isDeleteModalVisible
    } = this.state;
    if (!annotationState) return null;
    const isExistingAnnotation = typeof annotationState._id !== 'undefined';

    // Check the length of the text is within the max length limit,
    // and warn if the length is approaching the limit.
    const validationErrors = this.validateAnnotationText();
    const isInvalid = validationErrors.length > 0;
    const lengthRatioToShowWarning = 0.95;
    let helpText = null;
    if (isInvalid === false && annotationState.annotation.length > _annotations.ANNOTATION_MAX_LENGTH_CHARS * lengthRatioToShowWarning) {
      helpText = _i18n.i18n.translate('xpack.ml.timeSeriesExplorer.annotationFlyout.approachingMaxLengthWarning', {
        defaultMessage: '{charsRemaining, number} {charsRemaining, plural, one {character} other {characters}} remaining',
        values: {
          charsRemaining: _annotations.ANNOTATION_MAX_LENGTH_CHARS - annotationState.annotation.length
        }
      });
    }
    const detector = detectors ? detectors.find(d => d.index === detectorIndex) : undefined;
    const detectorDescription = detector && 'detector_description' in detector ? detector.detector_description : '';
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 334,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_annotation_description_list.AnnotationDescriptionList, {
      annotation: annotationState,
      detectorDescription: detectorDescription,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 335,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 339,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.timeSeriesExplorer.annotationFlyout.annotationTextLabel",
        defaultMessage: "Annotation text",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 342,
          columnNumber: 15
        }
      }),
      fullWidth: true,
      helpText: helpText,
      isInvalid: isInvalid,
      error: validationErrors,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 340,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextArea, {
      fullWidth: true,
      isInvalid: isInvalid,
      onChange: this.annotationTextChangeHandler,
      placeholder: "...",
      value: annotationState.annotation,
      "data-test-subj": 'mlAnnotationsFlyoutTextInput',
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 352,
        columnNumber: 13
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 361,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
      id: 'xpack.ml.annotationFlyout.applyToPartition',
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.annotationFlyout.applyToPartitionTextLabel",
        defaultMessage: "Apply annotation to this series",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 365,
          columnNumber: 17
        }
      }),
      checked: this.state.applyAnnotationToSeries,
      onChange: () => this.setState({
        applyAnnotationToSeries: !this.state.applyAnnotationToSeries
      }),
      "data-test-subj": 'mlAnnotationsFlyoutApplyToSeriesButton',
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 362,
        columnNumber: 13
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 380,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 381,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 382,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      onClick: this.cancelEditingHandler,
      flush: "left",
      "data-test-subj": 'mlAnnotationsFlyoutCancelButton',
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 383,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.timeSeriesExplorer.annotationFlyout.cancelButtonLabel",
      defaultMessage: "Cancel",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 388,
        columnNumber: 17
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      style: {
        marginLeft: 'auto'
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 394,
        columnNumber: 13
      }
    }, isExistingAnnotation && /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      color: "danger",
      onClick: this.deleteConfirmHandler,
      "data-test-subj": 'mlAnnotationsFlyoutDeleteButton',
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 396,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.timeSeriesExplorer.annotationFlyout.deleteButtonLabel",
      defaultMessage: "Delete",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 401,
        columnNumber: 19
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 408,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      fill: true,
      isDisabled: isInvalid === true,
      onClick: this.saveOrUpdateAnnotation,
      "data-test-subj": 'annotationFlyoutUpdateOrCreateButton',
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 409,
        columnNumber: 15
      }
    }, isExistingAnnotation ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.timeSeriesExplorer.annotationFlyout.updateButtonLabel",
      defaultMessage: "Update",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 416,
        columnNumber: 19
      }
    }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.timeSeriesExplorer.annotationFlyout.createButtonLabel",
      defaultMessage: "Create",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 421,
        columnNumber: 19
      }
    }))))), /*#__PURE__*/_react.default.createElement(_delete_annotation_modal.DeleteAnnotationModal, {
      cancelAction: this.closeDeleteModal,
      deleteAction: this.deleteHandler,
      isVisible: isDeleteModalVisible,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 430,
        columnNumber: 9
      }
    }));
  }
}
exports.AnnotationFlyoutUI = AnnotationFlyoutUI;
(0, _defineProperty2.default)(AnnotationFlyoutUI, "contextType", _public.context);
const AnnotationFlyout = props => {
  const annotationUpdatesService = (0, _react.useContext)(_ml_annotation_updates_context.MlAnnotationUpdatesContext);
  const annotationProp = (0, _useObservable.default)(annotationUpdatesService.isAnnotationInitialized$());
  const cancelEditingHandler = (0, _react.useCallback)(() => {
    annotationUpdatesService.setValue(null);
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  if (annotationProp === undefined || annotationProp === null) {
    return null;
  }
  const isExistingAnnotation = typeof annotationProp._id !== 'undefined';
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: cancelEditingHandler,
    size: "m",
    "aria-labelledby": "Add annotation",
    "data-test-subj": 'mlAnnotationFlyout',
    className: 'mlAnnotationFlyout',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 456,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 463,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    "data-test-subj": 'mlAnnotationFlyoutTitle',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 464,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: "mlAnnotationFlyoutTitle",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 465,
      columnNumber: 11
    }
  }, isExistingAnnotation ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.timeSeriesExplorer.annotationFlyout.editAnnotationTitle",
    defaultMessage: "Edit annotation",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 467,
      columnNumber: 15
    }
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.timeSeriesExplorer.annotationFlyout.addAnnotationTitle",
    defaultMessage: "Add annotation",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 472,
      columnNumber: 15
    }
  })))), /*#__PURE__*/_react.default.createElement(AnnotationFlyoutUI, (0, _extends2.default)({}, props, {
    annotationUpdatesService: annotationUpdatesService,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 480,
      columnNumber: 7
    }
  })));
};
exports.AnnotationFlyout = AnnotationFlyout;