"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.normalizeUnit = normalizeUnit;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const RATIO_FIELD_NAME_SUFFIX = 'utilization';
const normalizedUnitMap = {
  // otel
  by: 'bytes',
  '%': 'percent',
  '1': 'count',
  // ecs
  byte: 'bytes',
  nanos: 'ns',
  micros: 'us'
};
function normalizeUnit({
  fieldName,
  unit
}) {
  var _normalizedUnitMap$un;
  const isRatio = isRatioField(fieldName);
  if (!(unit !== null && unit !== void 0 && unit.trim()) && !isRatio) {
    return;
  }
  const normalizedUnit = unit ? (_normalizedUnitMap$un = normalizedUnitMap[unit.toLowerCase()]) !== null && _normalizedUnitMap$un !== void 0 ? _normalizedUnitMap$un : unit : undefined;
  if (isRatio && (!normalizedUnit || normalizedUnit === 'count')) {
    return 'percent';
  }
  return normalizedUnit;
}
function isRatioField(fieldName) {
  return fieldName.toLowerCase().includes(RATIO_FIELD_NAME_SUFFIX);
}