"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.host = void 0;
var _i18n = require("@kbn/i18n");
var _metrics = require("./metrics");
var _create_inventory_model = require("../shared/create_inventory_model");
var _constants = require("../../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const host = exports.host = (0, _create_inventory_model.createInventoryModel)('host', {
  displayName: _i18n.i18n.translate('xpack.metricsData.inventoryModel.host.displayName', {
    defaultMessage: 'Hosts'
  }),
  singularDisplayName: _i18n.i18n.translate('xpack.metricsData.inventoryModels.host.singularDisplayName', {
    defaultMessage: 'Host'
  }),
  requiredIntegration: {
    beats: 'system',
    otel: 'hostmetricsreceiver.otel'
  },
  crosslinkSupport: {
    details: true,
    logs: true,
    apm: true,
    uptime: true
  },
  fields: {
    id: 'host.name',
    name: 'host.name',
    os: 'host.os.name',
    ip: 'host.ip',
    cloudProvider: 'cloud.provider'
  },
  metrics: _metrics.metrics,
  nodeFilter: args => {
    const {
      schema
    } = args !== null && args !== void 0 ? args : {};
    if (!schema) {
      return [];
    }
    return [{
      bool: schema === 'ecs' ? {
        should: [{
          term: {
            [_constants.EVENT_MODULE]: _constants.SYSTEM_INTEGRATION
          }
        }, {
          term: {
            [_constants.METRICSET_MODULE]: _constants.SYSTEM_INTEGRATION
          }
        }],
        minimum_should_match: 1
      } : {
        filter: [{
          term: {
            [_constants.DATASTREAM_DATASET]: _constants.HOST_METRICS_RECEIVER_OTEL
          }
        }]
      }
    }];
  }
});