"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MapPage = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _map_app = require("./map_app");
var _saved_map = require("./saved_map");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/maps/public/routes/map_page/map_page.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
// react-router-dom.route "render" method may be called multiple times for the same route.
// Therefore state can not exist in the "render" closure
// MapAppContainer exists to wrap MapApp in a component so that a single instance of SavedMap
// exists per route regardless of how many times render method is called.
class MapPage extends _react.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "_isMounted", false);
    (0, _defineProperty2.default)(this, "updateSaveCounter", () => {
      if (this._isMounted) {
        this.setState(prevState => {
          return {
            saveCounter: prevState.saveCounter + 1
          };
        });
      }
    });
    this.state = {
      savedMap: new _saved_map.SavedMap({
        defaultLayers: (0, _saved_map.getInitialLayersFromUrlParam)(),
        mapEmbeddableState: props.mapEmbeddableState,
        embeddableId: props.embeddableId,
        originatingApp: props.originatingApp,
        originatingPath: props.originatingPath,
        stateTransfer: props.stateTransfer,
        onSaveCallback: this.updateSaveCounter,
        defaultLayerWizard: (0, _saved_map.getOpenLayerWizardFromUrlParam)() || ''
      }),
      saveCounter: 0
    };
  }
  componentDidMount() {
    this._isMounted = true;
  }
  componentWillUnmount() {
    this._isMounted = false;
  }
  render() {
    return /*#__PURE__*/_react.default.createElement(_reactRedux.Provider, {
      store: this.state.savedMap.getStore(),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 78,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_map_app.MapApp, {
      history: this.props.history,
      savedMap: this.state.savedMap,
      onAppLeave: this.props.onAppLeave,
      setHeaderActionMenu: this.props.setHeaderActionMenu,
      saveCounter: this.state.saveCounter,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 79,
        columnNumber: 9
      }
    }));
  }
}
exports.MapPage = MapPage;