"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Header = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/maps/public/connected_components/mb_map/tooltip_control/features_tooltip/header.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
class Header extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "_isMounted", false);
    (0, _defineProperty2.default)(this, "state", {
      layerName: null
    });
  }
  componentDidMount() {
    this._isMounted = true;
    this._loadLayerState();
  }
  componentWillUnmount() {
    this._isMounted = false;
  }
  async _loadLayerState() {
    const layer = this.props.findLayerById(this.props.layerId);
    if (!layer) {
      return;
    }
    const layerName = await layer.getDisplayName();
    if (this._isMounted) {
      this.setState({
        layerName
      });
    }
  }
  render() {
    const items = [];
    if (this.state.layerName) {
      items.push(/*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: true,
        key: "layerName",
        className: "eui-textTruncate",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 62,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 63,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement("h4", {
        className: "eui-textTruncate",
        title: this.state.layerName,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 64,
          columnNumber: 13
        }
      }, this.state.layerName))));
    }
    if (this.props.isLocked) {
      // When close button is the only item, add empty FlexItem to push close button to right
      if (items.length === 0) {
        items.push(/*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          key: "spacer",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 75,
            columnNumber: 20
          }
        }));
      }
      items.push(/*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        key: "closeButton",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 79,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
        onClick: this.props.onClose,
        iconType: "cross",
        "aria-label": _i18n.i18n.translate('xpack.maps.tooltip.closeAriaLabel', {
          defaultMessage: 'Close tooltip'
        }),
        "data-test-subj": "mapTooltipCloseButton",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 80,
          columnNumber: 11
        }
      })));
    }
    return items.length ? /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 93,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 94,
        columnNumber: 9
      }
    }, items), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
      margin: "xs",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 97,
        columnNumber: 9
      }
    })) : null;
  }
}
exports.Header = Header;