"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VectorStyleLabelBorderSizeEditor = VectorStyleLabelBorderSizeEditor;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _get_vector_style_label = require("../get_vector_style_label");
var _i18n = require("@kbn/i18n");
var _constants = require("../../../../../../common/constants");
var _disabled_tooltip = require("../../disabled_tooltip");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/maps/public/classes/styles/vector/components/label/vector_style_label_border_size_editor.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const options = [{
  value: _constants.LABEL_BORDER_SIZES.NONE,
  text: _i18n.i18n.translate('xpack.maps.styles.labelBorderSize.noneLabel', {
    defaultMessage: 'None'
  })
}, {
  value: _constants.LABEL_BORDER_SIZES.SMALL,
  text: _i18n.i18n.translate('xpack.maps.styles.labelBorderSize.smallLabel', {
    defaultMessage: 'Small'
  })
}, {
  value: _constants.LABEL_BORDER_SIZES.MEDIUM,
  text: _i18n.i18n.translate('xpack.maps.styles.labelBorderSize.mediumLabel', {
    defaultMessage: 'Medium'
  })
}, {
  value: _constants.LABEL_BORDER_SIZES.LARGE,
  text: _i18n.i18n.translate('xpack.maps.styles.labelBorderSize.largeLabel', {
    defaultMessage: 'Large'
  })
}];
function VectorStyleLabelBorderSizeEditor({
  disabled,
  disabledBy,
  handlePropertyChange,
  styleProperty
}) {
  function onChange(e) {
    const styleDescriptor = {
      options: {
        size: e.target.value
      }
    };
    handlePropertyChange(styleProperty.getStyleName(), styleDescriptor);
  }
  const labelBorderSizeForm = /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: (0, _get_vector_style_label.getVectorStyleLabel)(_constants.VECTOR_STYLES.LABEL_BORDER_SIZE),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    disabled: disabled,
    options: options,
    value: styleProperty.getOptions().size,
    onChange: onChange,
    "aria-label": _i18n.i18n.translate('xpack.maps.styles.labelBorderSizeSelect.ariaLabel', {
      defaultMessage: 'Select label border size'
    }),
    compressed: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 7
    }
  }));
  if (!disabled) {
    return labelBorderSizeForm;
  }
  return /*#__PURE__*/_react.default.createElement(_disabled_tooltip.DisabledToolTip, {
    content: (0, _get_vector_style_label.getDisabledByMessage)(disabledBy),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 5
    }
  }, labelBorderSizeForm);
}