"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LabelZoomRangeEditor = LabelZoomRangeEditor;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _public = require("@kbn/kibana-react-plugin/public");
var _get_vector_style_label = require("../get_vector_style_label");
var _disabled_tooltip = require("../../disabled_tooltip");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/maps/public/classes/styles/vector/components/label/label_zoom_range_editor.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function LabelZoomRangeEditor(props) {
  const layerZoomRange = props.styleProperty.getLayerZoomRange();
  const labelZoomRange = props.styleProperty.getLabelZoomRange();
  const onSwitchChange = event => {
    props.handlePropertyChange(props.styleProperty.getStyleName(), {
      options: {
        ...props.styleProperty.getOptions(),
        useLayerZoomRange: event.target.checked
      }
    });
  };
  const onZoomChange = value => {
    props.handlePropertyChange(props.styleProperty.getStyleName(), {
      options: {
        ...props.styleProperty.getOptions(),
        minZoom: Math.max(layerZoomRange.minZoom, parseInt(value[0], 10)),
        maxZoom: Math.min(layerZoomRange.maxZoom, parseInt(value[1], 10))
      }
    });
  };
  const {
    useLayerZoomRange
  } = props.styleProperty.getOptions();
  const slider = useLayerZoomRange ? null : /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    hasEmptyLabelSpace: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_public.ValidatedDualRange, {
    formRowDisplay: "columnCompressed",
    min: layerZoomRange.minZoom,
    max: layerZoomRange.maxZoom,
    value: [labelZoomRange.minZoom, labelZoomRange.maxZoom],
    showInput: "inputWithPopover",
    showRange: true,
    showLabels: true,
    onChange: onZoomChange,
    allowEmptyRange: false,
    compressed: true,
    prepend: _i18n.i18n.translate('xpack.maps.styles.labelZoomRange.visibleZoom', {
      defaultMessage: 'Zoom levels'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 7
    }
  }));
  const form = /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: (0, _get_vector_style_label.getVectorStyleLabel)(props.styleProperty.getStyleName()),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: _i18n.i18n.translate('xpack.maps.styles.labelZoomRange.useLayerZoomLabel', {
      defaultMessage: 'Use layer visibility'
    }),
    checked: useLayerZoomRange,
    onChange: onSwitchChange,
    compressed: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 9
    }
  })), slider);
  if (!props.disabled) {
    return form;
  }
  return /*#__PURE__*/_react.default.createElement(_disabled_tooltip.DisabledToolTip, {
    content: (0, _get_vector_style_label.getDisabledByMessage)(props.disabledBy),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 10
    }
  }, form);
}