"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UpdateSourceEditor = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/data-plugin/public");
var _i18nReact = require("@kbn/i18n-react");
var _i18n_getters = require("../../../../common/i18n_getters");
var _constants = require("../../../../common/constants");
var _single_field_select = require("../../../components/single_field_select");
var _tooltip_selector = require("../../../components/tooltip_selector");
var _kibana_services = require("../../../kibana_services");
var _index_pattern_util = require("../../../index_pattern_util");
var _es_doc_field = require("../../fields/es_doc_field");
var _scaling_form = require("./util/scaling_form");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/maps/public/classes/sources/es_search_source/update_source_editor.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
class UpdateSourceEditor extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "_isMounted", false);
    (0, _defineProperty2.default)(this, "state", {
      sourceFields: null,
      sortFields: undefined,
      supportsClustering: false,
      clusteringDisabledReason: null
    });
    (0, _defineProperty2.default)(this, "_onTooltipPropertiesChange", propertyNames => {
      this.props.onChange({
        propName: 'tooltipProperties',
        value: propertyNames
      });
    });
    (0, _defineProperty2.default)(this, "_onSortFieldChange", sortField => {
      this.props.onChange({
        propName: 'sortField',
        value: sortField
      });
    });
    (0, _defineProperty2.default)(this, "_onSortOrderChange", e => {
      this.props.onChange({
        propName: 'sortOrder',
        value: e.target.value
      });
    });
  }
  componentDidMount() {
    this._isMounted = true;
    this.loadFields();
  }
  componentWillUnmount() {
    this._isMounted = false;
  }
  async loadFields() {
    let indexPattern;
    try {
      indexPattern = await (0, _kibana_services.getIndexPatternService)().get(this.props.indexPatternId);
    } catch (err) {
      if (this._isMounted) {
        this.setState({
          loadError: (0, _i18n_getters.getDataViewNotFoundMessage)(this.props.indexPatternId)
        });
      }
      return;
    }
    let geoField;
    try {
      geoField = await this.props.getGeoField();
    } catch (err) {
      if (this._isMounted) {
        this.setState({
          loadError: err.message
        });
      }
      return;
    }
    if (!this._isMounted) {
      return;
    }

    // todo move this all to the source
    const rawTooltipFields = (0, _index_pattern_util.getSourceFields)(indexPattern.fields);
    const sourceFields = rawTooltipFields.map(field => {
      return new _es_doc_field.ESDocField({
        fieldName: field.name,
        source: this.props.source,
        origin: _constants.FIELD_ORIGIN.SOURCE
      });
    });
    this.setState({
      supportsClustering: (0, _index_pattern_util.supportsGeoTileAgg)(geoField),
      clusteringDisabledReason: (0, _index_pattern_util.getGeoTileAggNotSupportedReason)(geoField),
      sourceFields,
      sortFields: indexPattern.fields.filter(field => field.sortable && !_public.indexPatterns.isNestedField(field)) // todo change sort fields to use fields
    });
  }
  _renderTooltipsPanel() {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 133,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xs",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 134,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement("h5", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 135,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.maps.esSearch.tooltipsTitle",
      defaultMessage: "Tooltip fields",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 136,
        columnNumber: 13
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 143,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_tooltip_selector.TooltipSelector, {
      tooltipFields: this.props.tooltipFields,
      onChange: this._onTooltipPropertiesChange,
      fields: this.state.sourceFields,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 145,
        columnNumber: 9
      }
    }));
  }
  _renderSortPanel() {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 156,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xs",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 157,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement("h5", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 158,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.maps.esSearch.sortTitle",
      defaultMessage: "Sorting",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 159,
        columnNumber: 13
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 163,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: _i18n.i18n.translate('xpack.maps.source.esSearch.sortFieldLabel', {
        defaultMessage: 'Field'
      }),
      display: "columnCompressed",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 165,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_single_field_select.SingleFieldSelect, {
      placeholder: _i18n.i18n.translate('xpack.maps.source.esSearch.sortFieldSelectPlaceholder', {
        defaultMessage: 'Select sort field'
      }),
      value: this.props.sortField,
      onChange: this._onSortFieldChange,
      fields: this.state.sortFields,
      compressed: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 171,
        columnNumber: 11
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: _i18n.i18n.translate('xpack.maps.source.esSearch.sortOrderLabel', {
        defaultMessage: 'Order'
      }),
      display: "columnCompressed",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 182,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
      disabled: !this.props.sortField,
      options: [{
        text: _i18n.i18n.translate('xpack.maps.source.esSearch.ascendingLabel', {
          defaultMessage: 'ascending'
        }),
        value: _public.SortDirection.asc
      }, {
        text: _i18n.i18n.translate('xpack.maps.source.esSearch.descendingLabel', {
          defaultMessage: 'descending'
        }),
        value: _public.SortDirection.desc
      }],
      value: this.props.sortOrder,
      onChange: this._onSortOrderChange,
      compressed: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 188,
        columnNumber: 11
      }
    })));
  }
  _renderScalingPanel() {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 215,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_scaling_form.ScalingForm, {
      filterByMapBounds: this.props.filterByMapBounds,
      indexPatternId: this.props.indexPatternId,
      onChange: this.props.onChange,
      scalingType: this.props.scalingType,
      supportsClustering: this.state.supportsClustering,
      clusteringDisabledReason: this.state.clusteringDisabledReason,
      hasSpatialJoins: this.props.hasSpatialJoins,
      numberOfJoins: this.props.numberOfJoins,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 216,
        columnNumber: 9
      }
    }));
  }
  render() {
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 232,
        columnNumber: 7
      }
    }, this._renderTooltipsPanel(), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 234,
        columnNumber: 9
      }
    }), this._renderSortPanel(), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 237,
        columnNumber: 9
      }
    }), this._renderScalingPanel(), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 240,
        columnNumber: 9
      }
    }));
  }
}
exports.UpdateSourceEditor = UpdateSourceEditor;