"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.sourceTitle = exports.ESSearchSource = void 0;
exports.timerangeToTimeextent = timerangeToTimeextent;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _lodash = _interopRequireDefault(require("lodash"));
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _esQuery = require("@kbn/es-query");
var _rxjs = require("rxjs");
var _common = require("@kbn/data-plugin/common");
var _mapsVectorTileUtils = require("@kbn/maps-vector-tile-utils");
var _es_source = require("../es_source");
var _kibana_services = require("../../../kibana_services");
var _elasticsearch_util = require("../../../../common/elasticsearch_util");
var _update_source_editor = require("./update_source_editor");
var _constants = require("../../../../common/constants");
var _i18n_getters = require("../../../../common/i18n_getters");
var _index_pattern_util = require("../../../index_pattern_util");
var _load_index_settings = require("./util/load_index_settings");
var _constants2 = require("./constants");
var _es_doc_field = require("../../fields/es_doc_field");
var _vector_source = require("../vector_source");
var _valid_string_config = require("../../util/valid_string_config");
var _top_hits = require("./top_hits");
var _get_docvalue_source_fields = require("./util/get_docvalue_source_fields");
var _feature_edit = require("./util/feature_edit");
var _execution_context_utils = require("../execution_context_utils");
var _features_tooltip = require("../../../connected_components/mb_map/tooltip_control/features_tooltip");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/maps/public/classes/sources/es_search_source/es_search_source.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function timerangeToTimeextent(timerange) {
  const timeRangeBounds = (0, _kibana_services.getTimeFilter)().calculateBounds(timerange);
  return timeRangeBounds.min !== undefined && timeRangeBounds.max !== undefined ? {
    from: timeRangeBounds.min.valueOf(),
    to: timeRangeBounds.max.valueOf()
  } : undefined;
}
const sourceTitle = exports.sourceTitle = _i18n.i18n.translate('xpack.maps.source.esSearchTitle', {
  defaultMessage: 'Documents'
});
class ESSearchSource extends _es_source.AbstractESSource {
  static createDescriptor(descriptor) {
    const normalizedDescriptor = _es_source.AbstractESSource.createDescriptor(descriptor);
    if (!(0, _valid_string_config.isValidStringConfig)(normalizedDescriptor.geoField)) {
      throw new Error('Cannot create an ESSearchSourceDescriptor without a geoField');
    }
    return {
      ...normalizedDescriptor,
      type: _constants.SOURCE_TYPES.ES_SEARCH,
      geoField: normalizedDescriptor.geoField,
      filterByMapBounds: typeof descriptor.filterByMapBounds === 'boolean' ? descriptor.filterByMapBounds : _constants2.DEFAULT_FILTER_BY_MAP_BOUNDS,
      tooltipProperties: Array.isArray(descriptor.tooltipProperties) ? descriptor.tooltipProperties : [],
      sortField: (0, _valid_string_config.isValidStringConfig)(descriptor.sortField) ? descriptor.sortField : '',
      sortOrder: (0, _valid_string_config.isValidStringConfig)(descriptor.sortOrder) ? descriptor.sortOrder : _common.SortDirection.desc,
      scalingType: (0, _valid_string_config.isValidStringConfig)(descriptor.scalingType) ? descriptor.scalingType : _constants.SCALING_TYPES.MVT,
      topHitsGroupByTimeseries: typeof normalizedDescriptor.topHitsGroupByTimeseries === 'boolean' ? normalizedDescriptor.topHitsGroupByTimeseries : false,
      topHitsSplitField: (0, _valid_string_config.isValidStringConfig)(descriptor.topHitsSplitField) ? descriptor.topHitsSplitField : '',
      topHitsSize: typeof descriptor.topHitsSize === 'number' && descriptor.topHitsSize > 0 ? descriptor.topHitsSize : 1
    };
  }
  constructor(descriptor) {
    const sourceDescriptor = ESSearchSource.createDescriptor(descriptor);
    super(sourceDescriptor);
    (0, _defineProperty2.default)(this, "_descriptor", void 0);
    (0, _defineProperty2.default)(this, "_tooltipFields", void 0);
    this._descriptor = sourceDescriptor;
    this._tooltipFields = this._descriptor.tooltipProperties ? this._descriptor.tooltipProperties.map(property => {
      return this.getFieldByName(property);
    }) : [];
  }
  getGeoFieldName() {
    return this._descriptor.geoField;
  }
  renderSourceSettingsEditor(sourceEditorArgs) {
    if (this._isTopHits()) {
      return /*#__PURE__*/_react.default.createElement(_top_hits.TopHitsUpdateSourceEditor, {
        source: this,
        indexPatternId: this.getIndexPatternId(),
        onChange: sourceEditorArgs.onChange,
        tooltipFields: this._tooltipFields,
        sortField: this._descriptor.sortField,
        sortOrder: this._descriptor.sortOrder,
        filterByMapBounds: this.isFilterByMapBounds(),
        topHitsGroupByTimeseries: this._descriptor.topHitsGroupByTimeseries,
        topHitsSplitField: this._descriptor.topHitsSplitField,
        topHitsSize: this._descriptor.topHitsSize,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 168,
          columnNumber: 9
        }
      });
    }
    const getGeoField = () => {
      return this._getGeoField();
    };
    return /*#__PURE__*/_react.default.createElement(_update_source_editor.UpdateSourceEditor, {
      source: this,
      indexPatternId: this.getIndexPatternId(),
      getGeoField: getGeoField,
      onChange: sourceEditorArgs.onChange,
      tooltipFields: this._tooltipFields,
      sortField: this._descriptor.sortField,
      sortOrder: this._descriptor.sortOrder,
      scalingType: this._descriptor.scalingType,
      filterByMapBounds: this.isFilterByMapBounds(),
      numberOfJoins: sourceEditorArgs.numberOfJoins,
      hasSpatialJoins: sourceEditorArgs.hasSpatialJoins,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 187,
        columnNumber: 7
      }
    });
  }
  async getFields() {
    try {
      const indexPattern = await this.getIndexPattern();
      const fields = indexPattern.fields.filter(field => {
        // Ensure fielddata is enabled for field.
        // Search does not request _source
        return field.aggregatable;
      });
      return fields.map(field => {
        return this.getFieldByName(field.name);
      });
    } catch (error) {
      // failed index-pattern retrieval will show up as error-message in the layer-toc-entry
      return [];
    }
  }
  getFieldByName(fieldName) {
    return new _es_doc_field.ESDocField({
      fieldName,
      source: this,
      origin: _constants.FIELD_ORIGIN.SOURCE
    });
  }
  isMvt() {
    return this._descriptor.scalingType === _constants.SCALING_TYPES.MVT;
  }
  async getImmutableProperties() {
    let geoFieldType = '';
    try {
      const geoField = await this._getGeoField();
      geoFieldType = geoField.type;
    } catch (error) {
      // ignore error, geoFieldType will just be blank
    }
    return [{
      label: (0, _i18n_getters.getDataSourceLabel)(),
      value: sourceTitle
    }, {
      label: (0, _i18n_getters.getDataViewLabel)(),
      value: await this.getDisplayName()
    }, {
      label: _i18n.i18n.translate('xpack.maps.source.esSearch.geoFieldLabel', {
        defaultMessage: 'Geospatial field'
      }),
      value: this._descriptor.geoField
    }, {
      label: _i18n.i18n.translate('xpack.maps.source.esSearch.geoFieldTypeLabel', {
        defaultMessage: 'Geospatial field type'
      }),
      value: geoFieldType
    }];
  }

  // Returns sort content for an Elasticsearch search body
  _buildEsSort() {
    const {
      sortField,
      sortOrder
    } = this._descriptor;
    if (!sortField) {
      throw new Error('Cannot build sort');
    }
    return [{
      [sortField]: {
        order: sortOrder
      }
    }];
  }
  async _getTopHits(layerName, requestMeta, registerCancelCallback, inspectorAdapters) {
    const {
      topHitsGroupByTimeseries,
      topHitsSplitField: topHitsSplitFieldName,
      topHitsSize
    } = this._descriptor;
    if (!topHitsGroupByTimeseries && !topHitsSplitFieldName) {
      throw new Error('Cannot _getTopHits without topHitsSplitField');
    }
    const indexPattern = await this.getIndexPattern();
    const {
      docValueFields,
      sourceOnlyFields,
      scriptFields
    } = (0, _get_docvalue_source_fields.getDocValueAndSourceFields)(indexPattern, requestMeta.fieldNames, 'epoch_millis');
    const topHits = {
      size: topHitsSize,
      script_fields: scriptFields,
      docvalue_fields: docValueFields,
      fields: [this._descriptor.geoField]
    };
    if (this._hasSort()) {
      topHits.sort = this._buildEsSort();
    }
    if (sourceOnlyFields.length === 0) {
      topHits._source = false;
    } else {
      topHits._source = {
        includes: sourceOnlyFields
      };
    }
    const cardinalityAgg = {
      precision_threshold: 1
    };
    const termsAgg = {
      size: _constants.DEFAULT_MAX_BUCKETS_LIMIT,
      shard_size: _constants.DEFAULT_MAX_BUCKETS_LIMIT
    };
    const searchSource = await this.makeSearchSource(requestMeta, 0);
    searchSource.setField('trackTotalHits', false);
    if (topHitsGroupByTimeseries) {
      searchSource.setField('aggs', {
        totalEntities: {
          cardinality: {
            ...cardinalityAgg,
            field: '_tsid'
          }
        },
        entitySplit: {
          terms: {
            ...termsAgg,
            field: '_tsid'
          },
          aggs: {
            entityHits: {
              top_hits: topHits
            }
          }
        }
      });
    } else {
      const topHitsSplitField = (0, _elasticsearch_util.getField)(indexPattern, topHitsSplitFieldName);
      searchSource.setField('aggs', {
        totalEntities: {
          cardinality: (0, _elasticsearch_util.addFieldToDSL)(cardinalityAgg, topHitsSplitField)
        },
        entitySplit: {
          terms: (0, _elasticsearch_util.addFieldToDSL)(termsAgg, topHitsSplitField),
          aggs: {
            entityHits: {
              top_hits: topHits
            }
          }
        }
      });
      if (topHitsSplitField.type === 'string') {
        const entityIsNotEmptyFilter = (0, _esQuery.buildPhraseFilter)(topHitsSplitField, '', indexPattern);
        entityIsNotEmptyFilter.meta.negate = true;
        searchSource.setField('filter', [...searchSource.getField('filter'), entityIsNotEmptyFilter]);
      }
    }
    const warnings = [];
    const resp = await this._runEsQuery({
      requestId: this.getId(),
      requestName: (0, _vector_source.getLayerFeaturesRequestName)(layerName),
      searchSource,
      registerCancelCallback,
      searchSessionId: requestMeta.searchSessionId,
      executionContext: (0, _execution_context_utils.mergeExecutionContext)({
        description: 'es_search_source:top_hits'
      }, requestMeta.executionContext),
      requestsAdapter: inspectorAdapters.requests,
      onWarning: warning => {
        warnings.push(warning);
      }
    });
    const allHits = [];
    const entityBuckets = _lodash.default.get(resp, 'aggregations.entitySplit.buckets', []);
    const totalEntities = _lodash.default.get(resp, 'aggregations.totalEntities.value', 0);
    // can not compare entityBuckets.length to totalEntities because totalEntities is an approximate
    const areEntitiesTrimmed = entityBuckets.length >= _constants.DEFAULT_MAX_BUCKETS_LIMIT;
    let areTopHitsTrimmed = false;
    entityBuckets.forEach(entityBucket => {
      const hits = _lodash.default.get(entityBucket, 'entityHits.hits.hits', []);
      // Reverse hits list so top documents by sort are drawn on top
      allHits.push(...hits.slice().reverse());
      if ((0, _elasticsearch_util.isTotalHitsGreaterThan)(entityBucket.entityHits.hits.total, hits.length)) {
        areTopHitsTrimmed = true;
      }
    });
    return {
      hits: allHits,
      meta: {
        areResultsTrimmed: areEntitiesTrimmed || areTopHitsTrimmed,
        // used to force re-fetch when zooming in
        areEntitiesTrimmed,
        entityCount: entityBuckets.length,
        totalEntities,
        warnings
      }
    };
  }

  // Performs Elasticsearch search request being careful to pull back only required fields to minimize response size
  async _getSearchHits(layerName, requestMeta, registerCancelCallback, inspectorAdapters) {
    const warnings = [];
    const indexPattern = await this.getIndexPattern();
    const {
      docValueFields,
      sourceOnlyFields
    } = (0, _get_docvalue_source_fields.getDocValueAndSourceFields)(indexPattern, requestMeta.fieldNames, 'epoch_millis');
    const initialSearchContext = {
      docvalue_fields: docValueFields
    }; // Request fields in docvalue_fields insted of _source

    // Use Kibana global time extent instead of timeslice extent when all documents for global time extent can be loaded
    // to allow for client-side masking of timeslice
    const requestMetaWithoutTimeslice = {
      ...requestMeta
    };
    delete requestMetaWithoutTimeslice.timeslice;
    const useRequestMetaWithoutTimeslice = requestMeta.timeslice !== undefined && (await this.canLoadAllDocuments(layerName, requestMetaWithoutTimeslice, registerCancelCallback, inspectorAdapters, warning => {
      warnings.push(warning);
    }));
    const maxResultWindow = await this.getMaxResultWindow();
    const searchSource = await this.makeSearchSource(useRequestMetaWithoutTimeslice ? requestMetaWithoutTimeslice : requestMeta, maxResultWindow, initialSearchContext);
    searchSource.setField('trackTotalHits', maxResultWindow + 1);
    searchSource.setField('fieldsFromSource', requestMeta.fieldNames); // Setting "fields" filters out unused scripted fields
    if (sourceOnlyFields.length === 0) {
      searchSource.setField('source', false); // do not need anything from _source
    } else {
      searchSource.setField('source', sourceOnlyFields);
    }
    searchSource.setField('fields', [this._descriptor.geoField]);
    if (this._hasSort()) {
      searchSource.setField('sort', this._buildEsSort());
    }
    const resp = await this._runEsQuery({
      requestId: this.getId(),
      requestName: (0, _vector_source.getLayerFeaturesRequestName)(layerName),
      searchSource,
      registerCancelCallback,
      searchSessionId: requestMeta.searchSessionId,
      executionContext: (0, _execution_context_utils.mergeExecutionContext)({
        description: 'es_search_source:doc_search'
      }, requestMeta.executionContext),
      requestsAdapter: inspectorAdapters.requests,
      onWarning: warning => {
        warnings.push(warning);
      }
    });
    const isTimeExtentForTimeslice = requestMeta.timeslice !== undefined && !useRequestMetaWithoutTimeslice;
    return {
      hits: resp.hits.hits.slice().reverse(),
      // Reverse hits so top documents by sort are drawn on top
      meta: {
        resultsCount: resp.hits.hits.length,
        areResultsTrimmed: (0, _elasticsearch_util.isTotalHitsGreaterThan)(resp.hits.total, resp.hits.hits.length),
        timeExtent: isTimeExtentForTimeslice ? requestMeta.timeslice : timerangeToTimeextent(requestMeta.timeFilters),
        isTimeExtentForTimeslice,
        warnings
      }
    };
  }
  _isTopHits() {
    return this._descriptor.scalingType === _constants.SCALING_TYPES.TOP_HITS;
  }
  async _getSourceIndexList() {
    const dataView = await this.getIndexPattern();
    try {
      const {
        success,
        matchingIndexes
      } = await (0, _feature_edit.getMatchingIndexes)(dataView.getIndexPattern());
      return success ? matchingIndexes : [];
    } catch (e) {
      // Fail silently
      return [];
    }
  }
  async supportsFeatureEditing() {
    const matchingIndexes = await this._getSourceIndexList();
    // For now we only support 1:1 index-pattern:index matches
    return matchingIndexes.length === 1;
  }
  async _getNewFeatureFields() {
    if (!(await this._isDrawingIndex())) {
      return {};
    }
    const user = await (0, _kibana_services.getCore)().security.authc.getCurrentUser();
    const timestamp = new Date().toISOString();
    return {
      created: {
        ...(user ? {
          user: user.username
        } : {}),
        '@timestamp': timestamp
      }
    };
  }
  async _isDrawingIndex() {
    const dataView = await this.getIndexPattern();
    const {
      success,
      isDrawingIndex
    } = await (0, _feature_edit.getIsDrawLayer)(dataView.getIndexPattern());
    return success && isDrawingIndex;
  }
  _hasSort() {
    const {
      sortField,
      sortOrder
    } = this._descriptor;
    return !!sortField && !!sortOrder;
  }
  async getMaxResultWindow() {
    const dataView = await this.getIndexPattern();
    const indexSettings = await (0, _load_index_settings.loadIndexSettings)(dataView.getIndexPattern());
    return indexSettings.maxResultWindow;
  }

  /*
   * Changes in requestMeta.fieldNames requires re-fetch.
   * requestMeta.fieldNames are used to acheive smallest response possible.
   * Response only includes fields required for client usage.
   */
  isFieldAware() {
    return true;
  }
  getInspectorRequestIds() {
    return [this.getId(), this._getFeaturesCountRequestId()];
  }
  async getGeoJsonWithMeta(layerName, requestMeta, registerCancelCallback, isRequestStillActive, inspectorAdapters) {
    const indexPattern = await this.getIndexPattern();
    const {
      hits,
      meta
    } = this._isTopHits() ? await this._getTopHits(layerName, requestMeta, registerCancelCallback, inspectorAdapters) : await this._getSearchHits(layerName, requestMeta, registerCancelCallback, inspectorAdapters);
    const unusedMetaFields = indexPattern.metaFields.filter(metaField => {
      return !['_id', '_index'].includes(metaField);
    });
    const flattenHit = hit => {
      const properties = indexPattern.flattenHit(hit);
      // remove metaFields
      unusedMetaFields.forEach(metaField => {
        delete properties[metaField];
      });
      return properties;
    };
    const epochMillisFields = requestMeta.fieldNames.filter(fieldName => {
      const field = (0, _elasticsearch_util.getField)(indexPattern, fieldName);
      return field.readFromDocValues && field.type === 'date';
    });
    let featureCollection;
    try {
      const geoField = await this._getGeoField();
      featureCollection = (0, _elasticsearch_util.hitsToGeoJson)(hits, flattenHit, geoField.name, geoField.type, epochMillisFields);
    } catch (error) {
      throw new Error(_i18n.i18n.translate('xpack.maps.source.esSearch.convertToGeoJsonErrorMsg', {
        defaultMessage: 'Unable to convert search response to geoJson feature collection, error: {errorMsg}',
        values: {
          errorMsg: error.message
        }
      }));
    }
    return {
      data: featureCollection,
      meta
    };
  }
  hasTooltipProperties() {
    return this._tooltipFields.length > 0;
  }
  async _loadTooltipProperties(docId, index, indexPattern, executionContext) {
    if (this._tooltipFields.length === 0) {
      return {};
    }
    const searchService = (0, _kibana_services.getSearchService)();
    const searchSource = await searchService.searchSource.create();
    searchSource.setField('trackTotalHits', false);
    searchSource.setField('index', indexPattern);
    searchSource.setField('size', 1);
    const query = {
      language: 'kuery',
      query: `_id:"${docId}" and _index:"${index}"`
    };
    searchSource.setField('query', query);

    // searchSource calls dataView.getComputedFields to seed docvalueFields
    // dataView.getComputedFields adds each date field in the dataView to docvalueFields to ensure standardized date format across kibana
    // we don't need these as they request unneeded fields and bloat responses
    // setting fieldsFromSource notifies searchSource to filterout unused docvalueFields
    // '_id' is used since the value of 'fieldsFromSource' is irreverent because '_source: false'.
    searchSource.setField('fieldsFromSource', ['_id']);
    searchSource.setField('source', false);

    // Get all tooltip properties from fields API
    searchSource.setField('fields', this._getTooltipPropertyNames().map(fieldName => {
      const field = indexPattern.fields.getByName(fieldName);
      return field && field.type === 'date' ? {
        field: fieldName,
        format: 'strict_date_optional_time'
      } : fieldName;
    }));
    const {
      rawResponse: resp
    } = await (0, _rxjs.lastValueFrom)(searchSource.fetch$({
      legacyHitsTotal: false,
      executionContext: (0, _execution_context_utils.mergeExecutionContext)({
        description: 'es_search_source:load_tooltip_properties'
      }, executionContext)
    }));
    const hit = _lodash.default.get(resp, 'hits.hits[0]');
    if (!hit) {
      throw new Error(_i18n.i18n.translate('xpack.maps.source.esSearch.loadTooltipPropertiesErrorMsg', {
        defaultMessage: 'Unable to find document, _id: {docId}',
        values: {
          docId
        }
      }));
    }

    // @ts-expect-error hit's type is `SearchHit<{}>` while `flattenHit` expects `Record<string, unknown[]>`
    const properties = indexPattern.flattenHit(hit);
    indexPattern.metaFields.forEach(metaField => {
      if (!this._getTooltipPropertyNames().includes(metaField)) {
        delete properties[metaField];
      }
    });
    return properties;
  }
  _getTooltipPropertyNames() {
    return this._tooltipFields.map(field => field.getName());
  }
  async getTooltipProperties(properties, executionContext) {
    if (properties === null) {
      throw new Error('properties cannot be null');
    }
    const indexPattern = await this.getIndexPattern();
    const propertyValues = await this._loadTooltipProperties(properties._id, properties._index, indexPattern, executionContext);
    const tooltipProperties = this._tooltipFields.map(field => {
      const value = propertyValues[field.getName()];
      return field.createTooltipProperty(value);
    });
    return Promise.all(tooltipProperties);
  }
  isFilterByMapBounds() {
    if (this._descriptor.scalingType === _constants.SCALING_TYPES.CLUSTERS) {
      return true;
    } else if (this._descriptor.scalingType === _constants.SCALING_TYPES.MVT) {
      return false;
    } else {
      return !!this._descriptor.filterByMapBounds;
    }
  }
  async getLeftJoinFields() {
    const indexPattern = await this.getIndexPattern();
    // Left fields are retrieved from _source.
    return (0, _index_pattern_util.getSourceFields)(indexPattern.fields).map(field => {
      return this.getFieldByName(field.name);
    });
  }
  async getSupportedShapeTypes() {
    let geoFieldType;
    try {
      const geoField = await this._getGeoField();
      geoFieldType = geoField.type;
    } catch (error) {
      // ignore exeception
    }
    if (geoFieldType === _constants.ES_GEO_FIELD_TYPE.GEO_POINT) {
      return [_constants.VECTOR_SHAPE_TYPE.POINT];
    }
    return [_constants.VECTOR_SHAPE_TYPE.POINT, _constants.VECTOR_SHAPE_TYPE.LINE, _constants.VECTOR_SHAPE_TYPE.POLYGON];
  }
  getSourceStatus(sourceDataRequest) {
    var _meta$resultsCount2;
    const meta = sourceDataRequest ? sourceDataRequest.getMeta() : null;
    if (!meta) {
      // no tooltip content needed when there is no feature collection or meta
      return {
        tooltipContent: null,
        areResultsTrimmed: false
      };
    }
    if (this._isTopHits()) {
      var _meta$entityCount, _meta$totalEntities, _meta$entityCount2, _this$_descriptor$top;
      const entitiesFoundMsg = meta.areEntitiesTrimmed ? _i18n.i18n.translate('xpack.maps.esSearch.topHitsResultsTrimmedMsg', {
        defaultMessage: `Results limited to first {entityCount} entities of ~{totalEntities}.`,
        values: {
          entityCount: (_meta$entityCount = meta.entityCount) === null || _meta$entityCount === void 0 ? void 0 : _meta$entityCount.toLocaleString(),
          totalEntities: (_meta$totalEntities = meta.totalEntities) === null || _meta$totalEntities === void 0 ? void 0 : _meta$totalEntities.toLocaleString()
        }
      }) : _i18n.i18n.translate('xpack.maps.esSearch.topHitsEntitiesCountMsg', {
        defaultMessage: `Found {entityCount} entities.`,
        values: {
          entityCount: (_meta$entityCount2 = meta.entityCount) === null || _meta$entityCount2 === void 0 ? void 0 : _meta$entityCount2.toLocaleString()
        }
      });
      const docsPerEntityMsg = _i18n.i18n.translate('xpack.maps.esSearch.topHitsSizeMsg', {
        defaultMessage: `Showing top {topHitsSize} documents per entity.`,
        values: {
          topHitsSize: (_this$_descriptor$top = this._descriptor.topHitsSize) === null || _this$_descriptor$top === void 0 ? void 0 : _this$_descriptor$top.toLocaleString()
        }
      });
      return {
        tooltipContent: `${entitiesFoundMsg} ${docsPerEntityMsg}`,
        // Used to show trimmed icon in legend
        // user only needs to be notified of trimmed results when entities are trimmed
        areResultsTrimmed: !!meta.areEntitiesTrimmed
      };
    }
    if (meta.areResultsTrimmed) {
      var _meta$resultsCount;
      return {
        tooltipContent: _i18n.i18n.translate('xpack.maps.esSearch.resultsTrimmedMsg', {
          defaultMessage: `Results limited to first {count} documents.`,
          values: {
            count: (_meta$resultsCount = meta.resultsCount) === null || _meta$resultsCount === void 0 ? void 0 : _meta$resultsCount.toLocaleString()
          }
        }),
        areResultsTrimmed: true
      };
    }
    return {
      tooltipContent: _i18n.i18n.translate('xpack.maps.esSearch.featureCountMsg', {
        defaultMessage: `Found {count} documents.`,
        values: {
          count: (_meta$resultsCount2 = meta.resultsCount) === null || _meta$resultsCount2 === void 0 ? void 0 : _meta$resultsCount2.toLocaleString()
        }
      }),
      areResultsTrimmed: false
    };
  }
  getSyncMeta() {
    return {
      geoField: this._descriptor.geoField,
      filterByMapBounds: this._descriptor.filterByMapBounds,
      sortField: this._descriptor.sortField,
      sortOrder: this._descriptor.sortOrder,
      scalingType: this._descriptor.scalingType,
      topHitsGroupByTimeseries: this._descriptor.topHitsGroupByTimeseries,
      topHitsSplitField: this._descriptor.topHitsSplitField,
      topHitsSize: this._descriptor.topHitsSize
    };
  }

  // Returns geo_shape indexed_shape context for spatial quering by pre-indexed shapes
  async _getPreIndexedShape(properties) {
    if (properties === null) {
      return null;
    }
    const geoField = await this._getGeoField();
    return {
      index: properties._index,
      // Can not use index pattern title because it may reference many indices
      id: properties._id,
      path: geoField.name
    };
  }
  supportsJoins() {
    // can only join with features, not aggregated clusters
    return this._descriptor.scalingType !== _constants.SCALING_TYPES.CLUSTERS;
  }
  async _getEditableIndex() {
    const indexList = await this._getSourceIndexList();
    if (indexList.length === 0) {
      throw new Error(_i18n.i18n.translate('xpack.maps.source.esSearch.indexZeroLengthEditError', {
        defaultMessage: `Your data view doesn't point to any indices.`
      }));
    }
    if (indexList.length > 1) {
      throw new Error(_i18n.i18n.translate('xpack.maps.source.esSearch.indexOverOneLengthEditError', {
        defaultMessage: `Your data view points to multiple indices. Only one index is allowed per data view.`
      }));
    }
    return indexList[0];
  }
  async addFeature(geometry) {
    const index = await this._getEditableIndex();
    await (0, _feature_edit.addFeatureToIndex)(index, geometry, this.getGeoFieldName(), await this._getNewFeatureFields());
  }
  async deleteFeature(featureId) {
    const index = await this._getEditableIndex();
    await (0, _feature_edit.deleteFeatureFromIndex)(index, featureId);
  }
  getTileSourceLayer() {
    return 'hits';
  }
  async getTileUrl(requestMeta, refreshToken, hasLabels, buffer) {
    const dataView = await this.getIndexPattern();
    const indexSettings = await (0, _load_index_settings.loadIndexSettings)(dataView.getIndexPattern());
    const searchSource = await this.makeSearchSource(requestMeta, indexSettings.maxResultWindow);
    // searchSource calls dataView.getComputedFields to seed docvalueFields
    // dataView.getComputedFields adds each date field in the dataView to docvalueFields to ensure standardized date format across kibana
    // we don't need these as they request unneeded fields and bloat responses
    // setting fieldsFromSource notifies searchSource to filterout unused docvalueFields
    // '_id' is used since the value of 'fieldsFromSource' is irreverent because '_source: false'.
    searchSource.setField('fieldsFromSource', ['_id']);
    searchSource.setField('source', false);
    if (this._hasSort()) {
      searchSource.setField('sort', this._buildEsSort());
    }

    // use fields API
    searchSource.setField('fields', requestMeta.fieldNames.map(fieldName => {
      const field = dataView.fields.getByName(fieldName);
      return field && field.type === 'date' ? {
        field: fieldName,
        format: 'epoch_millis'
      } : fieldName;
    }));

    // Filter out documents without geo fields to avoid shard failures for indices without geo fields
    searchSource.setField('filter', [...searchSource.getField('filter'), (0, _esQuery.buildExistsFilter)({
      name: this._descriptor.geoField,
      type: 'geo_point'
    }, dataView)]);
    const mvtUrlServicePath = (0, _kibana_services.getHttp)().basePath.prepend(`${_constants.MVT_GETTILE_API_PATH}/{z}/{x}/{y}.pbf`);
    const tileUrlParams = (0, _mapsVectorTileUtils.getTileUrlParams)({
      geometryFieldName: this._descriptor.geoField,
      index: dataView.getIndexPattern(),
      hasLabels,
      buffer,
      requestBody: _lodash.default.pick(searchSource.getSearchRequestBody(), ['fields', 'query', 'runtime_mappings', 'size', 'sort']),
      token: refreshToken,
      executionContextId: (0, _execution_context_utils.getExecutionContextId)(requestMeta.executionContext)
    });
    return `${mvtUrlServicePath}?${tileUrlParams}`;
  }
  async getTimesliceMaskFieldName() {
    if (this._isTopHits() || this._descriptor.scalingType === _constants.SCALING_TYPES.MVT) {
      return null;
    }
    try {
      const indexPattern = await this.getIndexPattern();
      return indexPattern.timeFieldName ? indexPattern.timeFieldName : null;
    } catch (e) {
      // do not throw when index pattern does not exist, error will be surfaced by getGeoJsonWithMeta
      return null;
    }
  }
  getUpdateDueToTimeslice(prevMeta, timeslice) {
    if (this._isTopHits() || this._descriptor.scalingType === _constants.SCALING_TYPES.MVT) {
      return true;
    }
    if (prevMeta.timeExtent === undefined || prevMeta.areResultsTrimmed === undefined || prevMeta.areResultsTrimmed) {
      return true;
    }
    const isTimeExtentForTimeslice = prevMeta.isTimeExtentForTimeslice !== undefined ? prevMeta.isTimeExtentForTimeslice : false;
    if (!timeslice) {
      return isTimeExtentForTimeslice ?
      // Previous request only covers timeslice extent. Will need to re-fetch data to cover global time extent
      true :
      // Previous request covers global time extent.
      // No need to re-fetch data since previous request already has data for the entire global time extent.
      false;
    }
    const isWithin = isTimeExtentForTimeslice ? timeslice.from >= prevMeta.timeExtent.from && timeslice.to <= prevMeta.timeExtent.to : true;
    return !isWithin;
  }
  _getFeaturesCountRequestId() {
    return this.getId() + 'features_count';
  }
  async canLoadAllDocuments(layerName, requestMeta, registerCancelCallback, inspectorAdapters, onWarning) {
    const maxResultWindow = await this.getMaxResultWindow();
    const searchSource = await this.makeSearchSource(requestMeta, 0);
    searchSource.setField('trackTotalHits', maxResultWindow + 1);
    const resp = await this._runEsQuery({
      requestId: this._getFeaturesCountRequestId(),
      requestName: _i18n.i18n.translate('xpack.maps.vectorSource.featuresCountRequestName', {
        defaultMessage: 'load features count ({layerName})',
        values: {
          layerName
        }
      }),
      searchSource,
      registerCancelCallback,
      searchSessionId: requestMeta.searchSessionId,
      executionContext: (0, _execution_context_utils.mergeExecutionContext)({
        description: 'es_search_source:all_doc_counts'
      }, requestMeta.executionContext),
      requestsAdapter: inspectorAdapters.requests,
      onWarning
    });
    return !(0, _elasticsearch_util.isTotalHitsGreaterThan)(resp.hits.total, maxResultWindow);
  }
  getFeatureActions({
    addFilters,
    geoFieldNames,
    getActionContext,
    getFilterActions,
    mbFeature,
    onClose
  }) {
    if (geoFieldNames.length === 0 || addFilters === null) {
      return [];
    }
    const isPolygon = mbFeature.geometry.type === _constants.GEO_JSON_TYPE.POLYGON || mbFeature.geometry.type === _constants.GEO_JSON_TYPE.MULTI_POLYGON;
    return isPolygon ? [{
      label: _i18n.i18n.translate('xpack.maps.tooltip.action.filterByGeometryLabel', {
        defaultMessage: 'Filter by geometry'
      }),
      id: 'FILTER_BY_PRE_INDEXED_SHAPE_ACTION',
      form: /*#__PURE__*/_react.default.createElement(_features_tooltip.FeatureGeometryFilterForm, {
        onClose: onClose,
        geoFieldNames: geoFieldNames,
        addFilters: addFilters,
        getFilterActions: getFilterActions,
        getActionContext: getActionContext,
        loadPreIndexedShape: async () => {
          return this._getPreIndexedShape(mbFeature.properties);
        },
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 1060,
          columnNumber: 15
        }
      })
    }] : [];
  }
}
exports.ESSearchSource = ESSearchSource;