"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ResolutionEditor = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _constants = require("../../../../common/constants");
var _is_mvt = require("./is_mvt");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/maps/public/classes/sources/es_geo_grid_source/resolution_editor.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function isUnsupportedVectorTileMetric(metric) {
  return metric.type === _constants.AGG_TYPE.TERMS;
}
class ResolutionEditor extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "state", {
      showModal: false
    });
    (0, _defineProperty2.default)(this, "_onResolutionChange", event => {
      const resolution = this._sliderValueToResolution(parseInt(event.currentTarget.value, 10));
      if ((0, _is_mvt.isMvt)(this.props.renderAs, resolution)) {
        const hasUnsupportedMetrics = this.props.metrics.find(isUnsupportedVectorTileMetric);
        if (hasUnsupportedMetrics) {
          this.setState({
            showModal: true
          });
          return;
        }
      }
      this.props.onChange(resolution, this.props.metrics);
    });
    (0, _defineProperty2.default)(this, "_closeModal", () => {
      this.setState({
        showModal: false
      });
    });
    (0, _defineProperty2.default)(this, "_acceptModal", () => {
      this._closeModal();
      const supportedMetrics = this.props.metrics.filter(metric => {
        return !isUnsupportedVectorTileMetric(metric);
      });
      this.props.onChange(_constants.GRID_RESOLUTION.SUPER_FINE, supportedMetrics.length ? supportedMetrics : [{
        type: _constants.AGG_TYPE.COUNT
      }]);
    });
  }
  _getScale() {
    return this.props.renderAs === _constants.RENDER_AS.HEX ? {
      [_constants.GRID_RESOLUTION.SUPER_FINE]: 3,
      [_constants.GRID_RESOLUTION.MOST_FINE]: 2,
      [_constants.GRID_RESOLUTION.FINE]: 2,
      [_constants.GRID_RESOLUTION.COARSE]: 1
    } : {
      [_constants.GRID_RESOLUTION.SUPER_FINE]: 4,
      [_constants.GRID_RESOLUTION.MOST_FINE]: 3,
      [_constants.GRID_RESOLUTION.FINE]: 2,
      [_constants.GRID_RESOLUTION.COARSE]: 1
    };
  }
  _getTicks() {
    const scale = this._getScale();
    const unlabeledTicks = [{
      label: /*#__PURE__*/_react.default.createElement("span", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 57,
          columnNumber: 16
        }
      }, "\xA0"),
      value: scale[_constants.GRID_RESOLUTION.FINE]
    }];
    if (scale[_constants.GRID_RESOLUTION.FINE] !== scale[_constants.GRID_RESOLUTION.MOST_FINE]) {
      unlabeledTicks.push({
        label: /*#__PURE__*/_react.default.createElement("span", {
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 63,
            columnNumber: 16
          }
        }, "\xA0"),
        value: scale[_constants.GRID_RESOLUTION.MOST_FINE]
      });
    }
    return [{
      label: _i18n.i18n.translate('xpack.maps.source.esGrid.lowLabel', {
        defaultMessage: `low`
      }),
      value: scale[_constants.GRID_RESOLUTION.COARSE]
    }, ...unlabeledTicks, {
      label: _i18n.i18n.translate('xpack.maps.source.esGrid.highLabel', {
        defaultMessage: `high`
      }),
      value: scale[_constants.GRID_RESOLUTION.SUPER_FINE]
    }];
  }
  _resolutionToSliderValue(resolution) {
    const scale = this._getScale();
    return scale[resolution];
  }
  _sliderValueToResolution(value) {
    const scale = this._getScale();
    const resolution = Object.keys(scale).find(key => {
      return scale[key] === value;
    });
    return resolution ? resolution : _constants.GRID_RESOLUTION.COARSE;
  }
  _renderModal() {
    if (!this.state.showModal) return null;
    const confirmModalTitleId = (0, _eui.htmlIdGenerator)()('confirmModalTitle');
    return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
      "aria-labelledby": confirmModalTitleId,
      title: _i18n.i18n.translate('xpack.maps.source.esGrid.vectorTileModal.title', {
        defaultMessage: `'Top terms' metrics not supported`
      }),
      titleProps: {
        id: confirmModalTitleId
      },
      onCancel: this._closeModal,
      onConfirm: this._acceptModal,
      cancelButtonText: _i18n.i18n.translate('xpack.maps.source.esGrid.vectorTileModal.cancelBtnLabel', {
        defaultMessage: 'Cancel'
      }),
      confirmButtonText: _i18n.i18n.translate('xpack.maps.source.esGrid.vectorTileModal.confirmBtnLabel', {
        defaultMessage: 'Accept'
      }),
      buttonColor: "danger",
      defaultFocusedButton: "cancel",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 132,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 155,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.maps.source.esGrid.vectorTileModal.message",
      defaultMessage: "High resolution uses vector tiles from the Elasticsearch vector tile API. Elasticsearch vector tile API does not support 'Top terms' metric. Switching to super fine grid resolution will remove all 'Top terms' metrics from your layer configuration.",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 156,
        columnNumber: 11
      }
    })));
  }
  render() {
    const helpText = (this.props.renderAs === _constants.RENDER_AS.POINT || this.props.renderAs === _constants.RENDER_AS.GRID) && this.props.resolution === _constants.GRID_RESOLUTION.SUPER_FINE ? _i18n.i18n.translate('xpack.maps.source.esGrid.superFineHelpText', {
      defaultMessage: 'High resolution uses vector tiles.'
    }) : undefined;
    const ticks = this._getTicks();
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, this._renderModal(), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: _i18n.i18n.translate('xpack.maps.geoGrid.resolutionLabel', {
        defaultMessage: 'Resolution'
      }),
      helpText: helpText,
      display: "columnCompressed",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 177,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiRange, {
      value: this._resolutionToSliderValue(this.props.resolution),
      onChange: this._onResolutionChange,
      min: 1,
      max: ticks.length,
      showTicks: true,
      tickInterval: 1,
      ticks: ticks,
      compressed: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 184,
        columnNumber: 11
      }
    })));
  }
}
exports.ResolutionEditor = ResolutionEditor;